﻿within Physiomodel;
package UsersGuide "User's Guide"
  extends Modelica.Icons.Information;

  class Implementation "Implementation notes"
    extends Modelica.Icons.Information;

    annotation (Documentation(info="<html>
<p>The first version of Physiomodel integrates the model HumMod 1.6.1 (http://hummod.org), OSA(http://www.siggaard-andersen.dk/) and others - see References.</p>
<p>Default setting of the model is to the 73 kg 33 years old healthy man (human physiology is the part of mammalian physiology).</p>
</html>"));
  end Implementation;

  class References "References"
    extends Modelica.Icons.References;

    annotation (Documentation(info="<html>
<table cellspacing=\"0\" cellpadding=\"2\" border=\"0\">

	<tr>
		<td>[Abildgaard1986]</td>
		<td>U. Abildgaard, N.-H. Holstein-Rathlou, and P. P. Leyssac, \"Effect of renal nerve activity on tubular sodium and water reabsorption in dog kidneys as determined by the lithium clearance method,\" Acta Physiologica Scandinavica, vol. 126, pp. 251-257, 1986. </td>
	</tr>
	<tr>
		<td>[Abram2007]</td>
		<td>S. R. Abram, B. L. Hodnett, R. L. Summers, T. G. Coleman, and R. L. Hester, \"Quantitative circulatory physiology: an integrative mathematical model of human physiology for medical education,\" Advances in Physiology Education, vol. 31, pp. 202-210, 2007. </td>
	</tr>
	<tr>
		<td>[Abramson1958]</td>
		<td>D. I. Abramson, A. Kahn, S. Tuck Jr, G. A. Turman, H. Rejal, and C. J. Fleischer, \"Relationship between a range of tissue temperature and local oxygen uptake in the human forearm. I. Changes observed under resting conditions,\" Journal of Clinical Investigation, vol. 37, p. 1031, 1958. </td>
	</tr>
	<tr>
		<td>[Adair1982]</td>
		<td>T. H. Adair, D. S. Moffatt, A. W. Paulsen, and A. C. Guyton, Quantitation of changes in lymph protein concentration during lymph node transit vol. 243, 1982. </td>
	</tr>
	<tr>
		<td>[Adler1970]</td>
		<td>S. Adler, \"An extrarenal action of aldosterone on mammalian skeletal muscle,\" Am J Physiol, vol. 218, pp. 616-621, 1970. </td>
	</tr>
	<tr>
		<td>[Adolph1946]</td>
		<td>E. F. Adolph and G. W. Molnar, EXCHANGES OF HEAT AND TOLERANCES TO COLD IN MEN EXPOSED TO OUTDOOR WEATHER vol. 146, 1946. </td>
	</tr>
	<tr>
		<td>[Adrogue1985]</td>
		<td>H. J. Adrogue, Z. Chap, T. Ishida, and J. Field, \"Role of the endocrine pancreas in the kalemic response to acute metabolic acidosis in conscious dogs,\" Journal of Clinical Investigation, vol. 75, p. 798, 1985. </td>
	</tr>
	<tr>
		<td>[ADROGUÉ1986]</td>
		<td>H. J. ADROGUÉ, E. D. LEDERER, W. N. SUKI, and G. EKNOYAN, \"Determinants of Plasma Potassium Levels in Diabetic Ketoacidosis,\" Medicine, vol. 65, pp. 163-172, 1986. </td>
	</tr>
	<tr>
		<td>[Agostoni1962]</td>
		<td>E. Agostoni and G. Torri, Diaphragm contraction as a limiting factor to maximum expiration vol. 17, 1962. </td>
	</tr>
	<tr>
		<td>[Aguilera1978]</td>
		<td>G. Aguilera and K. Catt, \"Regulation of aldosterone secretion by the renin-angiotensin system during sodium restriction in rats,\" Proceedings of the National Academy of Sciences, vol. 75, pp. 4057-4061, 1978. </td>
	</tr>
	<tr>
		<td>[Ahlqvist2003]</td>
		<td>J. Ahlqvist, \"Plasma protein osmotic pressure equations for humans,\" Journal of Applied Physiology, vol. 94, pp. 1288-1289, 2003. </td>
	</tr>
	<tr>
		<td>[Albert1967]</td>
		<td>M. S. Albert, R. B. Dell, and R. W. Winters, \"Quantitative Displacement of Acid-Base Equilibrium in Metabolic Acidosis,\" Annals of Internal Medicine, vol. 66, pp. 312-322, 1967. </td>
	</tr>
	<tr>
		<td>[Alexander1978]</td>
		<td>G. Alexander, \"Cold thermogenesis,\" International review of physiology, vol. 20, pp. 43-155, 1978. </td>
	</tr>
	<tr>
		<td>[Alexander1955]</td>
		<td>J. K. Alexander, H. F. Spalter, and J. R. West, \"MODIFICATION OF THE RESPIRATORY RESPONSE TO CARBON DIOXIDE BY SALICYLATE,\" The Journal of Clinical Investigation, vol. 34, pp. 533-537, 1955. </td>
	</tr>
	<tr>
		<td>[Alfie1999]</td>
		<td>J. Alfie, G. D. Waisman, C. R. Galarza, and M. I. Cámera, \"Contribution of Stroke Volume to the Change in Pulse Pressure Pattern With Age,\" Hypertension, vol. 34, pp. 808-812, October 1, 1999 1999. </td>
	</tr>
	<tr>
		<td>[Algenstaedt2004]</td>
		<td>P. Algenstaedt, N. Rosenblatt, I. Kolb, A. Krützelmann, B. Schwarzloh, A. Böttcher, et al., \"A new model of primary human adipocytes reveals reduced early insulin signalling in type 2 diabetes,\" Hormone and Metabolic Research = Hormon- Und Stoffwechselforschung = Hormones Et Métabolisme, vol. 36, pp. 531-537, 2004/08// 2004. </td>
	</tr>
	<tr>
		<td>[Almgard1975]</td>
		<td>L. Almgard and A. Ljungqvist, \"Effect of circulating norepinephrine on the renin release from the denervated kidney,\" Scandinavian journal of urology and nephrology, vol. 9, pp. 119-124, 1975. </td>
	</tr>
	<tr>
		<td>[Alsberge1988]</td>
		<td>M. Alsberge, M. Magno, and M. Lipschutz, Carotid body control of bronchial circulation in sheep vol. 65, 1988. </td>
	</tr>
	<tr>
		<td>[Ames1965]</td>
		<td>R. P. Ames, A. J. Borkowski, A. M. Sicinski, and J. H. Laragh, \"Prolonged infusions of angiotensin II and norepinephrine and blood pressure, electrolyte balance, and aldosterone and cortisol secretion in normal man and in cirrhosis with ascites,\" Journal of Clinical Investigation, vol. 44, p. 1171, 1965. </td>
	</tr>
	<tr>
		<td>[Anderson1985]</td>
		<td>K. E. Anderson, E. Pantuck, A. H. Conney, and A. Kappas, \"Nutrient regulation of chemical metabolism in humans,\" in Federation proceedings, 1985, pp. 130-133. </td>
	</tr>
	<tr>
		<td>[Andres1962]</td>
		<td>R. Andres, M. A. Baltzan, G. Cader, and K. L. Zierler, \"Effect of insulin on carbohydrate metabolism and on potassium in the forearm of man,\" Journal of Clinical Investigation, vol. 41, p. 108, 1962. </td>
	</tr>
	<tr>
		<td>[Angielski1978]</td>
		<td>S. Angielski and J. Lukowicz, \"The role of the kidney in the removal of ketone bodies under different acid-base status of the rat,\" The American Journal of Clinical Nutrition, vol. 31, pp. 1635-41, September 1, 1978 1978. </td>
	</tr>
	<tr>
		<td>[Arendshorst1985]</td>
		<td>W. J. Arendshorst and C. W. Gottschalk, Glomerular ultrafiltration dynamics: historical perspective vol. 248, 1985. </td>
	</tr>
	<tr>
		<td>[Archer2002]</td>
		<td>S. Archer and E. Michelakis, The Mechanism(s) of Hypoxic Pulmonary Vasoconstriction: Potassium Channels, Redox O2 Sensors, and Controversies vol. 17, 2002. </td>
	</tr>
	<tr>
		<td>[Archer1996]</td>
		<td>S. L. Archer, J. M. C. Huang, H. L. Reeve, V. Hampl, S. Tolarová, E. Michelakis, et al., \"Differential Distribution of Electrophysiologically Distinct Myocytes in Conduit and Resistance Arteries Determines Their Response to Nitric Oxide and Hypoxia,\" Circulation Research, vol. 78, pp. 431-442, March 1, 1996 1996. </td>
	</tr>
	<tr>
		<td>[Armstrong1991]</td>
		<td>L. E. Armstrong and C. M. Maresh, \"The induction and decay of heat acclimatisation in trained athletes,\" Sports Medicine, vol. 12, pp. 302-312, 1991. </td>
	</tr>
	<tr>
		<td>[Armstrong1985]</td>
		<td>R. Armstrong, C. Vandenakker, and M. Laughlin, \"Muscle blood flow patterns during exercise in partially curarized rats,\" Journal of Applied Physiology, vol. 58, pp. 698-701, 1985. </td>
	</tr>
	<tr>
		<td>[Arner2002]</td>
		<td>P. Arner, \"Insulin resistance in type 2 diabetes: role of fatty acids,\" Diabetes/metabolism research and reviews, vol. 18, pp. S5-S9, 2002. </td>
	</tr>
	<tr>
		<td>[Ashley1992]</td>
		<td>K. D. Ashley, D. N. Herndon, L. D. Traber, D. L. Traber, K. Deubel-Ashley, J. Stothert, et al., \"Systemic blood flow to sheep lung: comparison of flow probes and microspheres,\" Journal of Applied Physiology, vol. 73, pp. 1996-1996, 1992. </td>
	</tr>
	<tr>
		<td>[Atherton1971]</td>
		<td>J. Atherton, R. Green, and S. Thomas, \"Influence of lysine-vasopressin dosage on the time course of changes in renal tissue and urinary composition in the conscious rat,\" The Journal of physiology, vol. 213, pp. 291-309, 1971. </td>
	</tr>
	<tr>
		<td>[Atchley1933]</td>
		<td>D. W. Atchley, R. F. Loeb, D. W. Richards, Jr., E. M. Benedict, and M. E. Driscoll, \"ON DIABETIC ACIDOSIS: A Detailed Study of Electrolyte Balances Following the Withdrawal and Reestablishment of Insulin Therapy,\" The Journal of Clinical Investigation, vol. 12, pp. 297-326, 1933. </td>
	</tr>
	<tr>
		<td>[Atkins1962]</td>
		<td>E. L. Atkins and W. B. Schwartz, \"Factors governing correction of the alkalosis associated with potassium deficiency; the critical role of chloride in the recovery process,\" Journal of Clinical Investigation, vol. 41, p. 218, 1962. </td>
	</tr>
	<tr>
		<td>[Aukland1989]</td>
		<td>K. Aukland, \"Myogenic mechanisms in the kidney,\" Journal of hypertension. Supplement: official journal of the International Society of Hypertension, vol. 7, pp. S71-6; discussion S77, 1989. </td>
	</tr>
	<tr>
		<td>[Aukland1993]</td>
		<td>K. Aukland and R. K. Reed, \"Interstitial-lymphatic mechanisms in the control of extracellular fluid volume,\" Physiological Reviews, vol. 73, pp. 1-78, January 1, 1993 1993. </td>
	</tr>
	<tr>
		<td>[Aukland1993]</td>
		<td>K. Aukland and R. Reed, \"Interstitial-lymphatic mechanisms in the control of extracellular fluid volume,\" Physiological reviews, vol. 73, pp. 1-78, 1993. </td>
	</tr>
	<tr>
		<td>[Avery1961]</td>
		<td>M. E. Avery and C. D. Cook, Volume-pressure relationships of lungs and thorax in fetal, newborn, and adult goats vol. 16, 1961. </td>
	</tr>
	<tr>
		<td>[Badder1977]</td>
		<td>E. M. Badder, J. F. Seaton, and T. S. Harrison, \"Arterial and venous catecholamine responses to passive orthostatic stimulation,\" Surgical forum, vol. 28, pp. 115-118, 1977 1977. </td>
	</tr>
	<tr>
		<td>[Bachelard1974]</td>
		<td>H. S. Bachelard, L. D. Lewis, U. Pontén, and B. K. Siesjö, \"MECHANISMS ACTIVATING GLYCOLYSIS IN THE BRAIN IN ARTERIAL HYPOXIA,\" Journal of Neurochemistry, vol. 22, pp. 395-401, 1974. </td>
	</tr>
	<tr>
		<td>[Baldes1934]</td>
		<td>E. J. Baldes and F. Smirk, \"The effect of water drinking, mineral starvation and salt administration on the total osmotic pressure of the blood in man, chiefly in relation to the problems of water absorption and water diuresis,\" The Journal of physiology, vol. 82, pp. 62-74, 1934. </td>
	</tr>
	<tr>
		<td>[Baldes1934]</td>
		<td>E. J. Baldes and F. H. Smirk, \"The effect of water drinking, mineral starvation and salt administration on the total osmotic pressure of the blood in man, chiefly in relation to the problems of water absorption and water diuresis,\" The Journal of Physiology, vol. 82, pp. 62-74, August 24, 1934 1934. </td>
	</tr>
	<tr>
		<td>[Bangsbo1997]</td>
		<td>J. Bangsbo, C. Juel, Y. Hellsten, and B. Saltin, \"Dissociation between lactate and proton exchange in muscle during intense exercise in man,\" The Journal of Physiology, vol. 504, pp. 489-499, October 15, 1997 1997. </td>
	</tr>
	<tr>
		<td>[Barger1958]</td>
		<td>A. Barger, R. Berlin, and J. Tulenko, \"INFUSION OF ALDOSTERONE, 9-?-FLUOROHYDROCORTISONE AND ANTIDIURETIC HORMONE INTO THE RENAL ARTERY OF NORMAL AND ADRENALECTOMIZED, UNANESTHETIZED DOGS: EFFECT ON ELECTROLYTE AND WATER EXCRETION 1,\" Endocrinology, vol. 62, pp. 804-815, 1958. </td>
	</tr>
	<tr>
		<td>[Barnard1987]</td>
		<td>P. Barnard, S. Andronikou, M. Pokorski, N. Smatresk, A. Mokashi, and S. Lahiri, Time-dependent effect of hypoxia on carotid body chemosensory function vol. 63, 1987. </td>
	</tr>
	<tr>
		<td>[Bassingthwaighte1997]</td>
		<td>J. B. Bassingthwaighte, \"Design and strategy for the Cardionome Project,\" in Analytical and Quantitative Cardiology, ed: Springer, 1997, pp. 325-339. </td>
	</tr>
	<tr>
		<td>[Bassingthwaighte2000]</td>
		<td>J. B. Bassingthwaighte, \"Strategies for the physiome project,\" Annals of Biomedical Engineering, vol. 28, pp. 1043-1058, 2000. </td>
	</tr>
	<tr>
		<td>[BAUER1993]</td>
		<td>C. BAUER, \"A WIDESPREAD OXYGEN SENSOR REVEALED,\" ed: C/O WILLIAMS & WILKINS, PO BOX 1496, BALTIMORE, MD 21203, 1993. </td>
	</tr>
	<tr>
		<td>[Bauer1979]</td>
		<td>J. H. Bauer and W. C. Gauntner, \"Effect of potassium chloride on plasma renin activity and plasma aldosterone during sodium restriction in normal man,\" Kidney Int, vol. 15, pp. 286-293, 03//print 1979. </td>
	</tr>
	<tr>
		<td>[Bazett1997]</td>
		<td>H. C. Bazett, \"AN ANALYSIS OF THE TIME-RELATIONS OF ELECTROCARDIOGRAMS,\" Annals of Noninvasive Electrocardiology, vol. 2, pp. 177-194, 1997. </td>
	</tr>
	<tr>
		<td>[Becklake1989]</td>
		<td>M. R. Becklake, \"Occupational Exposures: Evidence for a Causal Association with Chronic Obstructive Pulmonary Disease,\" American Review of Respiratory Disease, vol. 140, pp. S85-S91, 1989/09/01 1989. </td>
	</tr>
	<tr>
		<td>[Beeken1962]</td>
		<td>W. L. Beeken, W. Volwiler, P. D. Goldsworthy, L. E. Garby, W. E. Reynolds, R. Stogsdill, et al., \"Studies of I131-albumin catabolism and distribution in normal young male adults,\" Journal of Clinical Investigation, vol. 41, p. 1312, 1962. </td>
	</tr>
	<tr>
		<td>[Begg1966]</td>
		<td>T. Begg and J. Hearns, \"Components in blood viscosity. The relative contribution of haematocrit, plasma fibrinogen and other proteins,\" Clinical science, vol. 31, pp. 87-93, 1966. </td>
	</tr>
	<tr>
		<td>[Bello-Reuss1975]</td>
		<td>E. Bello-Reuss, R. Colindres, E. Pastoriza-Munoz, R. Mueller, and C. Gottschalk, \"Effects of acute unilateral renal denervation in the rat,\" Journal of Clinical Investigation, vol. 56, p. 208, 1975. </td>
	</tr>
	<tr>
		<td>[Bengis1979]</td>
		<td>R. Bengis and T. Coleman, \"Antihypertensive effect of prolonged blockade of angiotensin formation in benign and malignant, one-and two-kidney Goldblatt hypertensive rats,\" Clin Sci, vol. 57, pp. 53-62, 1979. </td>
	</tr>
	<tr>
		<td>[Bennett1993]</td>
		<td>F. M. Bennett and W. E. Fordyce, \"Regulation of PaCO2 during rest and exercise: a modeling study,\" Ann Biomed Eng, vol. 21, pp. 545-55, Sep-Oct 1993. </td>
	</tr>
	<tr>
		<td>[Benzinger1969]</td>
		<td>T. H. Benzinger, \"Heat regulation: homeostasis of central temperature in man,\" Physiological Reviews, vol. 49, pp. 671-759, 1969. </td>
	</tr>
	<tr>
		<td>[Berde1968]</td>
		<td>B. Berde and R. Boissonnas, Basic pharmacological properties of synthetic analogues and homologues of the neurohypophysial hormones: Springer, 1968. </td>
	</tr>
	<tr>
		<td>[Berg1997]</td>
		<td>B. R. Berg, K. D. Cohen, and I. H. Sarelius, \"Direct coupling between blood flow and metabolism at the capillary level in striated muscle,\" American Journal of Physiology-Heart and Circulatory Physiology, vol. 41, p. H2693, 1997. </td>
	</tr>
	<tr>
		<td>[Berkenbosch1979]</td>
		<td>A. Berkenbosch, J. Van Dissel, C. N. Olievier, J. De Goede, and J. Heeringa, \"The contribution of the peripheral chemoreceptors to the ventilatory response to CO2 in anaesthetized cats during hyperoxia,\" Respiration Physiology, vol. 37, pp. 381-390, 8// 1979. </td>
	</tr>
	<tr>
		<td>[Bevegärd1962]</td>
		<td>S. Bevegärd and A. Lodin, \"Postural Circulatory Changes at Rest and during Exercise in five Patients with Congenital Absence of Valves in the Deep Veins of the Legs,\" Acta Medica Scandinavica, vol. 172, pp. 21-29, 1962. </td>
	</tr>
	<tr>
		<td>[Biscoe1970]</td>
		<td>T. J. Biscoe, M. J. Purves, and S. R. Sampson, \"The frequency of nerve impulses in single carotid body chemoreceptor afferent fibres recorded in vivo with intact circulation,\" The Journal of Physiology, vol. 208, pp. 121-131, May 1, 1970 1970. </td>
	</tr>
	<tr>
		<td>[Black1971]</td>
		<td>A. M. Black, D. I. McCloskey, and R. W. Torrance, \"The responses of carotid body chemoreceptors in the cat to sudden changes of hypercapnic and hypoxic stimuli,\" Respir Physiol, vol. 13, pp. 36-49, Oct 1971. </td>
	</tr>
	<tr>
		<td>[Blackard1970]</td>
		<td>W. G. Blackard and N. C. Nelson, \"Portal and Peripheral Vein Immunoreactive Insulin Concentrations Before and After Glucose Infusion,\" Diabetes, vol. 19, pp. 302-306, May 1, 1970 1970. </td>
	</tr>
	<tr>
		<td>[Blackard1974]</td>
		<td>W. G. Blackard, N. C. Nelson, and S. S. Andrews, \"Portal and Peripheral Vein Immunoreactive Glucagon Concentrations After Arginine or Glucose Infusions,\" Diabetes, vol. 23, pp. 199-202, March 1, 1974 1974. </td>
	</tr>
	<tr>
		<td>[Blatteis1997]</td>
		<td>C. M. Blatteis and E. Sehic, \"Fever: how may circulating pyrogens signal the brain?,\" News in Physiological Sciences, vol. 12, pp. 1-8, 1997. </td>
	</tr>
	<tr>
		<td>[Block1952]</td>
		<td>M. A. Block, K. G. Wakim, and F. C. Mann, \"Renal function during stimulation of renal nerves,\" Am J Physiol, vol. 169, pp. 670-677, 1952. </td>
	</tr>
	<tr>
		<td>[Bock1930]</td>
		<td>A. V. Bock, D. B. Dill, and H. T. Edwards, \"ON THE RELATION OF CHANGES IN BLOOD VELOCITY AND VOLUME FLOW OF BLOOD TO CHANGE OF POSTURE,\" The Journal of Clinical Investigation, vol. 8, pp. 533-544, 1930. </td>
	</tr>
	<tr>
		<td>[Bonvalet1990]</td>
		<td>J. Bonvalet, \"Aldosterone-sensitive cells in the kidney: new insights,\" News Physiol Sci, vol. 6, pp. 201-205, 1990. </td>
	</tr>
	<tr>
		<td>[Bootsma1994]</td>
		<td>M. Bootsma, C. A. Swenne, H. H. Van Bolhuis, P. C. Chang, V. M. Cats, and A. Bruschke, \"Heart rate and heart rate variability as indexes of sympathovagal balance,\" American Journal of Physiology, vol. 266, pp. H1565-H1565, 1994. </td>
	</tr>
	<tr>
		<td>[Borgdorff1990]</td>
		<td>P. Borgdorff, D. R. Gross, R. Burattini, P. Duijst, and N. Westerhof, \"Short-term systemic autoregulation,\" Am J Physiol Heart Circ Physiol, vol. 258, pp. H1097-H1102, 1990. </td>
	</tr>
	<tr>
		<td>[Borgström1975]</td>
		<td>L. Borgström, H. Jóhannsson, and B. K. Siesjö, \"The Relationship between Arterial PO2 and Cerebral Blood Flow in Hypoxic Hypoxia,\" Acta Physiologica Scandinavica, vol. 93, pp. 423-432, 1975. </td>
	</tr>
	<tr>
		<td>[Braam1993]</td>
		<td>B. Braam, K. D. Mitchell, H. A. Koomans, and L. G. Navar, \"Relevance of the tubuloglomerular feedback mechanism in pathophysiology,\" Journal of the American Society of Nephrology, vol. 4, pp. 1257-1274, 1993. </td>
	</tr>
	<tr>
		<td>[BRADLEY1952]</td>
		<td>S. E. BRADLEY, F. J. INGELFINGER, and G. P. BRADLEY, \"Hepatic Circulation in Cirrhosis of the Liver,\" Circulation, vol. 5, pp. 419-429, March 1, 1952 1952. </td>
	</tr>
	<tr>
		<td>[Bradley2000]</td>
		<td>R. L. Bradley, K. A. Cleveland, and B. Cheatham, \"The adipocyte as a secretory organ: mechanisms of vesicle transport and secretory pathways,\" Recent progress in hormone research, vol. 56, pp. 329-358, 2000. </td>
	</tr>
	<tr>
		<td>[Bradley1953]</td>
		<td>S. E. Bradley, P. A. Marks, P. C. Reynell, and J. Meltzer, \"The circulating splanchnic blood volume in dog and man,\" Trans Assoc Am Physicians, vol. 66, pp. 294-302, 1953. </td>
	</tr>
	<tr>
		<td>[Braunwald1976]</td>
		<td>E. Braunwald, J. Ross, and E. H. Sonnenblick, Mechanisms of contraction of the normal and failing heart: Little, Brown Boston, 1976. </td>
	</tr>
	<tr>
		<td>[Braunwald1961]</td>
		<td>E. Braunwald, R. D. Bloodwell, L. I. Goldberg, and A. G. Morrow, \"STUDIES ON DIGITALIS. IV. OBSERVATIONS IN MAN ON THE EFFECTS OF DIGITALIS PREPARATIONS ON THE CONTRACTILITY OF THE NON-FAILING HEART AND ON TOTAL VASCULAR RESISTANCE,\" The Journal of Clinical Investigation, vol. 40, pp. 52-59, 1961. </td>
	</tr>
	<tr>
		<td>[Brebbia1957]</td>
		<td>D. R. Brebbia, R. F. Goldman, and E. R. Buskirk, Water Vapor Loss From the Respiratory Tract During Outdoor Exercise in the Cold vol. 11, 1957. </td>
	</tr>
	<tr>
		<td>[Brenner1977]</td>
		<td>B. M. Brenner and H. D. Humes, \"Mechanics of Glomerular Ultrafiltration,\" New England Journal of Medicine, vol. 297, pp. 148-154, 1977. </td>
	</tr>
	<tr>
		<td>[Brenner1977]</td>
		<td>B. M. Brenner and H. D. Humes, \"Mechanics of glomerular ultrafiltration,\" N Engl J Med, vol. 297, pp. 148-54, Jul 21 1977. </td>
	</tr>
	<tr>
		<td>[Breslow1993]</td>
		<td>M. J. Breslow, J. R. Tobin, D. S. Bredt, C. D. Ferris, S. H. Snyder, and R. J. Traystman, Nitric oxide as a regulator of adrenal blood flow vol. 264, 1993. </td>
	</tr>
	<tr>
		<td>[Brezis1995]</td>
		<td>M. Brezis and S. Rosen, \"Hypoxia of the Renal Medulla — Its Implications for Disease,\" New England Journal of Medicine, vol. 332, pp. 647-655, 1995. </td>
	</tr>
	<tr>
		<td>[Briscoe1958]</td>
		<td>W. A. Briscoe and A. B. Dubois, \"The Relationship Between Airway Resistance, Airway Conductance and Lung Volume in Subjects of Different Age and Body Size12,\" The Journal of Clinical Investigation, vol. 37, pp. 1279-1285, 1958. </td>
	</tr>
	<tr>
		<td>[Brown1982]</td>
		<td>M. J. Brown, F. J. M. Lhoste, C. Zamboulis, P. W. Ind, D. A. Jenner, and C. T. Dollery, \"Estimation of sympathetic activity in essential hypertension,\" Clin. Pharm. Ther., vol. 31, pp. 16-22, 01//print 1982. </td>
	</tr>
	<tr>
		<td>[Brugard2009]</td>
		<td>J. Brugard, D. Hedberg, M. Cascante, G. Cedersund, A. Gómez-Garrido, D. Maier, et al., \"Creating a Bridge between Modelica and the Systems Biology Community,\" in 7th International Modelica Conference, Como, Italy, 2009. </td>
	</tr>
	<tr>
		<td>[Brugard2009]</td>
		<td>J. Brugard, D. Hedberg, M. Cascante, G. Cedersund, A. Gómez-Garrido, D. Maier, et al., \"Creating a Bridge between Modelica and the Systems Biology Community,\" in 7th International Modelica Conference, Como, Italy, 2009. </td>
	</tr>
	<tr>
		<td>[BRUNNER1979]</td>
		<td>H. R. BRUNNER, H. GAVRAS, B. WAEBER, G. R. KERSHAW, G. A. TURINI, R. A. VUKOVICH, et al., \"Oral angiotensin-converting enzyme inhibitor in long-term treatment of hypertensive patients,\" Annals of internal medicine, vol. 90, pp. 19-23, 1979. </td>
	</tr>
	<tr>
		<td>[Bruun1990]</td>
		<td>N. Bruun, P. Skott, N. M. Damkjaer, S. Rasmussen, H. Schütten, A. Leth, et al., \"Normal renal tubular response to changes of sodium intake in hypertensive man,\" Journal of hypertension, vol. 8, pp. 219-227, 1990. </td>
	</tr>
	<tr>
		<td>[Buckey1988]</td>
		<td>J. C. Buckey, R. M. Peshock, and C. G. Blomqvist, \"Deep venous contribution to hydrostatic blood volume change in the human leg,\" Am J Cardiol, vol. 62, pp. 449-53, Sep 1 1988. </td>
	</tr>
	<tr>
		<td>[Burattini1994]</td>
		<td>R. Burattini, P. Borgdorff, and N. Westerhof, \"Relationship between strength of short-term systemic autoregulation and initial resistance,\" American Journal of Physiology-Regulatory Integrative and Comparative Physiology, vol. 36, p. R1182, 1994. </td>
	</tr>
	<tr>
		<td>[Burton1935]</td>
		<td>A. C. Burton, \"Human Calorimetry II. The Average Temperature of the Tissues of the BodyThree Figures,\" The Journal of Nutrition, vol. 9, pp. 261-280, 1935. </td>
	</tr>
	<tr>
		<td>[Bushinsky1982]</td>
		<td>D. A. Bushinsky, F. L. Coe, C. Katzenberg, J. P. Szidon, and J. H. Parks, \"Arterial Pco2 in chronic metabolic acidosis,\" Kidney Int, vol. 22, pp. 311-314, 09//print 1982. </td>
	</tr>
	<tr>
		<td>[Butler1960]</td>
		<td>J. Butler, C. G. Caro, R. Alcala, and A. B. DuBois, \"PHYSIOLOGICAL FACTORS AFFECTING AIRWAY RESISTANCE IN NORMAL SUBJECTS AND IN PATIENTS WITH OBSTRUCTIVE RESPIRATORY DISEASE*,\" The Journal of Clinical Investigation, vol. 39, pp. 584-591, 1960. </td>
	</tr>
	<tr>
		<td>[Cahan1990]</td>
		<td>C. Cahan, P. Hoekje, E. Goldwasser, M. Decker, and K. Strohl, \"Assessing the characteristic between length of hypoxic exposure and serum erythropoietin levels,\" Am. J. Physiol, vol. 258, pp. R1016-R1021, 1990. </td>
	</tr>
	<tr>
		<td>[Cahill1970]</td>
		<td>G. F. Cahill, \"Starvation in Man,\" New England Journal of Medicine, vol. 282, pp. 668-675, 1970. </td>
	</tr>
	<tr>
		<td>[Cahill1981]</td>
		<td>G. F. Cahill, Jr., \"Ketosis,\" Kidney Int, vol. 20, pp. 416-425, 09//print 1981. </td>
	</tr>
	<tr>
		<td>[Carlson1954]</td>
		<td>L. D. Carlson, \"The Adequate Stimulus for Shivering,\" Experimental Biology and Medicine, vol. 85, pp. 303-305, February 1, 1954 1954. </td>
	</tr>
	<tr>
		<td>[Carlson1971]</td>
		<td>L. Carlson, L. Ekelund, and S. Fröberg, \"Concentration of triglycerides, phospholipids and glycogen in skeletal muscle and of free fatty acids and beta-hydroxybutyric acid in blood in man in response to exercise,\" European journal of clinical investigation, vol. 1, pp. 248-254, 1971. </td>
	</tr>
	<tr>
		<td>[Carter1998]</td>
		<td>Y. M. Carter, C. X. Jia, P. F. Soto, J. P. Starr, D. G. Rabkin, D. T. Hsu, et al., \"Diastolic properties, myocardial water content, and histologic condition of the rat left ventricle: effect of varied osmolarity of a coronary perfusate,\" The Journal of heart and lung transplantation : the official publication of the International Society for Heart Transplantation, vol. 17, pp. 140-149, 1998/02// 1998. </td>
	</tr>
	<tr>
		<td>[Case1977]</td>
		<td>D. B. Case, J. M. Wallace, H. J. Keim, M. A. Weber, J. E. Sealey, and J. H. Laragh, \"Possible role of renin in hypertension as suggested by renin-sodium profiling and inhibition of converting enzyme,\" New England Journal of Medicine, vol. 296, pp. 641-646, 1977. </td>
	</tr>
	<tr>
		<td>[Cellier2005]</td>
		<td>F. E. Cellier and A. Nebot, \"Object-oriented Modeling in the Service of Medicine,\" in Proc. 6th Asia Simulation Conference, 2005, pp. 33-40. </td>
	</tr>
	<tr>
		<td>[LLC2012]</td>
		<td>L. b. U. o. M. M. Center, \"HumMod,\" p. http://hummod.org/, 2012. </td>
	</tr>
	<tr>
		<td>[Clutter1980]</td>
		<td>W. E. Clutter, D. M. Bier, S. D. Shah, and P. E. Cryer, \"Epinephrine plasma metabolic clearance rates and physiologic thresholds for metabolic and hemodynamic actions in man,\" Journal of Clinical Investigation, vol. 66, p. 94, 1980. </td>
	</tr>
	<tr>
		<td>[Clutter1980]</td>
		<td>W. E. Clutter, D. M. Bier, S. D. Shah, and P. E. Cryer, \"Epinephrine plasma metabolic clearance rates and physiologic thresholds for metabolic and hemodynamic actions in man,\" The Journal of Clinical Investigation, vol. 66, pp. 94-101, 1980. </td>
	</tr>
	<tr>
		<td>[Clutter1980]</td>
		<td>W. E. Clutter, D. M. Bier, S. D. Shah, and P. E. Cryer, \"Epinephrine plasma metabolic clearance rates and physiologic thresholds for metabolic and hemodynamic actions in man,\" The Journal of Clinical Investigation, vol. 66, pp. 94-101, 1980. </td>
	</tr>
	<tr>
		<td>[Cogan1979]</td>
		<td>M. G. Cogan, D. A. Maddox, M. S. Lucci, F. C. Rector Jr, M. R. Mueller, and K. R. Wong, \"Control of proximal bicarbonate reabsorption in normal and acidotic rats,\" Journal of Clinical Investigation, vol. 64, p. 1168, 1979. </td>
	</tr>
	<tr>
		<td>[Cogan1979]</td>
		<td>M. G. Cogan, D. A. Maddox, M. S. Lucci, F. C. Rector Jr, M. R. Mueller, and K. R. Wong, \"Control of proximal bicarbonate reabsorption in normal and acidotic rats,\" Journal of Clinical Investigation, vol. 64, p. 1168, 1979. </td>
	</tr>
	<tr>
		<td>[Coleman1973]</td>
		<td>D. L. Coleman, \"Effects of parabiosis of obese with diabetes and normal mice,\" Diabetologia, vol. 9, pp. 294-298, 1973/08/01 1973. </td>
	</tr>
	<tr>
		<td>[Coleman1983]</td>
		<td>T. G. Coleman and J. E. Randall, \"A Comprehensive Physiological Model,\" The Physiologist, vol. 26, 1983. </td>
	</tr>
	<tr>
		<td>[Coleman1972]</td>
		<td>T. G. Coleman, R. D. Manning, Jr., R. A. Norman, Jr., and A. C. Guyton, \"Dynamics of water-isotope distribution,\" Am J Physiol, vol. 223, pp. 1371-5, Dec 1972. </td>
	</tr>
	<tr>
		<td>[Collins-Nakai1994]</td>
		<td>R. L. Collins-Nakai, D. Noseworthy, and G. D. Lopaschuk, \"Epinephrine increases ATP production in hearts by preferentially increasing glucose metabolism,\" Am J Physiol, vol. 267, pp. H1862-71, Nov 1994. </td>
	</tr>
	<tr>
		<td>[Conci2001]</td>
		<td>F. Conci, M. Di Rienzo, and P. Castiglioni, \"Blood pressure and heart rate variability and baroreflex sensitivity before and after brain death,\" Journal of Neurology, Neurosurgery & Psychiatry, vol. 71, pp. 621-631, 2001. </td>
	</tr>
	<tr>
		<td>[Considine1996]</td>
		<td>R. V. Considine, M. K. Sinha, M. L. Heiman, A. Kriauciunas, T. W. Stephens, M. R. Nyce, et al., \"Serum Immunoreactive-Leptin Concentrations in Normal-Weight and Obese Humans,\" New England Journal of Medicine, vol. 334, pp. 292-295, 1996. </td>
	</tr>
	<tr>
		<td>[Consolazio1961]</td>
		<td>C. F. Consolazio, R. Shapiro, J. E. Masterson, and P. S. McKinzie, \"Energy requirements of men in extreme heat,\" The Journal of Nutrition, vol. 73, pp. 126-134, 1961. </td>
	</tr>
	<tr>
		<td>[Consolazio1963]</td>
		<td>C. F. Consolazio, L. O. Matoush, R. A. Nelson, J. B. Torres, and G. J. Isaac, \"Environmental temperature and energy expenditures,\" J Appl Physiol, vol. 18, pp. 65-68, 1963. </td>
	</tr>
	<tr>
		<td>[Conte1992]</td>
		<td>G. Conte, G. Romano, V. Sepe, L. De Nicola, M. Sabbatini, D. Russo, et al., \"Role of inhibition of atrial natriuretic factor release in the down-regulation of salt excretion,\" Kidney Int, vol. 42, pp. 673-680, 1992. </td>
	</tr>
	<tr>
		<td>[Cortney1966]</td>
		<td>M. Cortney, W. Nagel, and K. Thurau, \"A micropuncture study of the relationship between flow-rate through the loop of Henle and sodium concentration in the early distal tubule,\" Pflüger's Archiv für die gesamte Physiologie des Menschen und der Tiere, vol. 287, pp. 286-295, 1966/09/01 1966. </td>
	</tr>
	<tr>
		<td>[Cota2006]</td>
		<td>D. Cota, K. Proulx, K. A. B. Smith, S. C. Kozma, G. Thomas, S. C. Woods, et al., \"Hypothalamic mTOR Signaling Regulates Food Intake,\" Science, vol. 312, pp. 927-930, May 12, 2006 2006. </td>
	</tr>
	<tr>
		<td>[Cox1978]</td>
		<td>M. Cox, R. H. Sterns, and I. Singer, \"The Defense against Hyperkalemia: The Roles of Insulin and Aldosterone,\" New England Journal of Medicine, vol. 299, pp. 525-532, 1978. </td>
	</tr>
	<tr>
		<td>[Cryer1993]</td>
		<td>P. E. Cryer, Glucose counterregulation: prevention and correction of hypoglycemia in humans vol. 264, 1993. </td>
	</tr>
	<tr>
		<td>[Cumin1996]</td>
		<td>F. Cumin, H. P. Baum, and N. Levens, \"Leptin is cleared from the circulation primarily by the kidney,\" International journal of obesity and related metabolic disorders : journal of the International Association for the Study of Obesity, vol. 20, pp. 1120-1126, 1996/12// 1996. </td>
	</tr>
	<tr>
		<td>[Dash1975]</td>
		<td>S. Dash, K. Chugh, R. Nath, and P. Wahi, \"Effect of rapid lowering of blood pressure on renal function in hypertensives with renal failure,\" The Indian journal of medical research, vol. 63, pp. 902-909, 1975. </td>
	</tr>
	<tr>
		<td>[Davidson1986]</td>
		<td>D. Davidson, S. A. Stalcup, and R. B. Mellins, Systemic hemodynamics affecting cardiac output during hypocapnic and hypercapnic hypoxia vol. 60, 1986. </td>
	</tr>
	<tr>
		<td>[de1992]</td>
		<td>D. de Zeeuw, W. M. Janssen, and P. E. de Jong, \"Atrial natriuretic factor: its (patho) physiological significance in humans,\" Kidney Int, vol. 41, pp. 1115-33, 1992. </td>
	</tr>
	<tr>
		<td>[DeFronzo1980]</td>
		<td>R. A. DeFronzo, P. Felig, E. Ferrannini, and J. Wahren, \"Effect of graded doses of in"
             + "sulin on splanchnic and peripheral potassium metabolism in man,\" Am J Physiol, vol. 238, pp. E421-7, 1980. </td>
	</tr>
	<tr>
		<td>[Defronzo1978]</td>
		<td>R. A. Defronzo, R. S. Sherwin, M. Dillingham, R. Hendler, W. V. Tamborlane, and P. Felig, \"Influence of basal insulin and glucagon secretion on potassium and sodium metabolism: studies with somatostatin in normal dogs and in normal and diabetic human beings,\" Journal of Clinical Investigation, vol. 61, p. 472, 1978. </td>
	</tr>
	<tr>
		<td>[Degroot1977]</td>
		<td>L. J. Degroot and H. Niepomniszcze, \"Biosynthesis of thyroid hormone: basic and clinical aspects,\" Metabolism, vol. 26, pp. 665-718, 1977. </td>
	</tr>
	<tr>
		<td>[Deheneffe1976]</td>
		<td>J. Deheneffe, V. Cuesta, J. Briggs, J. Brown, R. Fraser, A. Lever, et al., \"Response of aldosterone and blood pressure to angiotensin II infusion in anephric man. Effect of sodium deprivation,\" Circulation research, vol. 39, pp. 183-190, 1976. </td>
	</tr>
	<tr>
		<td>[Devaux1968]</td>
		<td>C. Devaux, J. Menard, J.-M. Alexandre, J.-M. Idatte, P. Meyer, and P. Milliez, \"Variations in renin and its substrate after binephrectomy,\" The Lancet, vol. 291, p. 300, 1968. </td>
	</tr>
	<tr>
		<td>[DiBona1997]</td>
		<td>G. F. DiBona and U. C. Kopp, Neural control of renal function vol. 77, 1997. </td>
	</tr>
	<tr>
		<td>[Dighe2004]</td>
		<td>A. S. Dighe, F. J. Hayes, J. Khosravi, U. Bodani, and P. M. Sluss, \"Comparison of Inhibin A Immunoassays: Recommendation for Adoption of Standardized Reporting,\" Clinical Chemistry, vol. 50, pp. 767-769, April 1, 2004 2004. </td>
	</tr>
	<tr>
		<td>[Dill1941]</td>
		<td>D. B. Dill and W. H. Forbes, RESPIRATORY AND METABOLIC EFFECTS OF HYPOTHERMIA vol. 132, 1941. </td>
	</tr>
	<tr>
		<td>[Dimri1980]</td>
		<td>G. Dimri, M. Malhotra, J. S. Gupta, T. S. Kumar, and B. Arora, \"Alterations in aerobic-anaerobic proportions of metabolism during work in heat,\" European journal of applied physiology and occupational physiology, vol. 45, pp. 43-50, 1980. </td>
	</tr>
	<tr>
		<td>[Dobson1967]</td>
		<td>H. L. Dobson, L. Robbins, P. C. Johnson, J. Mdalel, D. D. Odem, G. Cornwall, et al., \"Absorption of 131-I labeled modified insulin,\" Metabolism, vol. 16, pp. 723-732, 8// 1967. </td>
	</tr>
	<tr>
		<td>[Dodt1952]</td>
		<td>E. Dodt and Y. Zotterman, \"Mode of action of warm receptors,\" Acta physiologica scandinavica, vol. 26, pp. 345-357, 1952. </td>
	</tr>
	<tr>
		<td>[DOEDEN1987]</td>
		<td>B. DOEDEN and R. RIZZA, \"Use of a Variable Insulin Infusion to Assess Insulin Action in Obesity: Defects in Both the Kinetics and Amplitude of Response,\" The Journal of Clinical Endocrinology & Metabolism, vol. 64, pp. 902-908, 1987. </td>
	</tr>
	<tr>
		<td>[Donnan1911]</td>
		<td>F. G. Donnan, \"Theorie der Membrangleichgewichte und Membranpotentiale bei Vorhandensein von nicht dialysierenden Elektrolyten. Ein Beitrag zur physikalisch-chemischen Physiologie,\" Zeitschrift für Elektrochemie und angewandte physikalische Chemie, vol. 17, pp. 572-581, 1911. </td>
	</tr>
	<tr>
		<td>[Drake2002]</td>
		<td>R. E. Drake and M. F. Doursout, Pulmonary Edema and Elevated Left Atrial Pressure: Four Hours and Beyond vol. 17, 2002. </td>
	</tr>
	<tr>
		<td>[DREES1974]</td>
		<td>J. A. DREES and C. F. Rothe, \"Reflex venoconstriction and capacity vessel pressure-volume relationships in dogs,\" Circulation research, vol. 34, pp. 360-373, 1974. </td>
	</tr>
	<tr>
		<td>[Drenick1972]</td>
		<td>E. J. Drenick, L. C. Alvarez, G. C. Tamasi, and A. S. Brickman, \"Resistance to Symptomatic Insulin Reactions after Fasting,\" The Journal of Clinical Investigation, vol. 51, pp. 2757-2762, 1972. </td>
	</tr>
	<tr>
		<td>[Drummond2008]</td>
		<td>H. A. Drummond, S. C. Grifoni, and N. L. Jernigan, \"A new trick for an old dogma: ENaC proteins as mechanotransducers in vascular smooth muscle,\" Physiology, vol. 23, pp. 23-31, 2008. </td>
	</tr>
	<tr>
		<td>[Drury1927]</td>
		<td>A. Drury and N. Jones, \"Observations upon the rate at which oedema forms when the veins of the human limb are congested,\" Heart, vol. 14, p. 8, 1927. </td>
	</tr>
	<tr>
		<td>[Drury1927]</td>
		<td>A. Drury and N. Jones, \"Observations upon the rate at which oedema forms when the veins of the human limb are congested,\" Heart, vol. 14, p. 8, 1927. </td>
	</tr>
	<tr>
		<td>[Duffin1972]</td>
		<td>J. Duffin, \"A mathematical model of the chemoreflex control of ventilation,\" Respiration Physiology, vol. 15, pp. 277-301, 7// 1972. </td>
	</tr>
	<tr>
		<td>[Duffin2000]</td>
		<td>J. Duffin, R. M. Mohan, P. Vasiliou, R. Stephenson, and S. Mahamed, \"A model of the chemoreflex control of breathing in humans: model parameters measurement,\" Respiration Physiology, vol. 120, pp. 13-26, 3// 2000. </td>
	</tr>
	<tr>
		<td>[Dunbar2001]</td>
		<td>S. L. Dunbar, L. Tamhidi, D. E. Berkowitz, and A. A. Shoukas, Hindlimb unweighting affects rat vascular capacitance function vol. 281, 2001. </td>
	</tr>
	<tr>
		<td>[Dunnill1973]</td>
		<td>M. S. Dunnill and W. Halley, \"Some observations on the quantitative anatomy of the kidney,\" The Journal of Pathology, vol. 110, pp. 113-121, 1973. </td>
	</tr>
	<tr>
		<td>[Dyckner1978]</td>
		<td>T. Dyckner and P. O. Wester, \"Ventricular Extrasystoles and Intracellular Electrolytes in Hypokalemic Patients before and after Correction of the Hypokalemia,\" Acta Medica Scandinavica, vol. 204, pp. 375-379, 1978. </td>
	</tr>
	<tr>
		<td>[Ebeling1994]</td>
		<td>P. Ebeling and V. A. Koivisto, \"Non-esterified fatty acids regulate lipid and glucose oxidation and glycogen synthesis in healthy man,\" Diabetologia, vol. 37, pp. 202-209, 1994/02/01 1994. </td>
	</tr>
	<tr>
		<td>[Eckardt1989]</td>
		<td>K. U. Eckardt, A. Kurtz, and C. Bauer, \"Regulation of erythropoietin production is related to proximal tubular function,\" The American journal of physiology. Renal physiology, vol. 256, pp. F942-F947, 1989. </td>
	</tr>
	<tr>
		<td>[Eckardt1990]</td>
		<td>K. U. Eckardt, A. Kurtz, and C. Bauer, \"Triggering of erythropoietin production by hypoxia is inhibited by respiratory and metabolic acidosis,\" The American journal of physiology : AJP. Regu Physiol, vol. 258, pp. R678-R683, 1990. </td>
	</tr>
	<tr>
		<td>[Edelman1974]</td>
		<td>I. S. Edelman, \"Thyroid Thermogenesis,\" New England Journal of Medicine, vol. 290, pp. 1303-1308, 1974. </td>
	</tr>
	<tr>
		<td>[ECHT1974]</td>
		<td>M. ECHT, J. DÜWELING, O. H. GAUER, and L. LANGE, \"Effective Compliance of the Total Vascular Bed and the Intrathoracic Compartment Derived from Changes in Central Venous Pressure Induced by Volume Changes in Man,\" Circulation Research, vol. 34, pp. 61-68, January 1, 1974 1974. </td>
	</tr>
	<tr>
		<td>[Eisenhoffer1994]</td>
		<td>J. Eisenhoffer, S. Lee, and M. Johnston, \"Pressure-flow relationships in isolated sheep prenodal lymphatic vessels,\" American Journal of Physiology-Heart and Circulatory Physiology, vol. 36, p. H938, 1994. </td>
	</tr>
	<tr>
		<td>[Elmqvist2003]</td>
		<td>H. Elmqvist, H. Tummescheit, and M. Otter, \"Object-oriented modeling of thermo-fluid systems,\" in 3rd International Modelica Conference, 2003, pp. 269-286. </td>
	</tr>
	<tr>
		<td>[Elsasser1980]</td>
		<td>V. Elsasser, R. Hesp, L. Klenerman, and R. Wootton, \"Deficit of trabecular and cortical bone in elderly women with fracture of the femoral neck,\" Clin Sci, vol. 59, pp. 393-395, 1980. </td>
	</tr>
	<tr>
		<td>[Engelson1999]</td>
		<td>V. Engelson, H. Larsson, and P. Fritzson, \"A design, simulation and visualization environment for object-oriented mechanical and multi-domain models in Modelica,\" in Information Visualization, 1999. Proceedings. 1999 IEEE International Conference on, 1999, pp. 188-193. </td>
	</tr>
	<tr>
		<td>[Engeset1973]</td>
		<td>A. Engeset, B. Hager, A. Nesheim, and A. Kolbenstvedt, \"Studies on human peripheral lymph. I. Sampling method,\" Lymphology, vol. 6, pp. 1-5, 1973. </td>
	</tr>
	<tr>
		<td>[Engeset1973]</td>
		<td>A. Engeset, B. Hager, A. Nesheim, and A. Kolbenstvedt, \"Studies on human peripheral lymph. I. Sampling method,\" Lymphology, vol. 6, pp. 1-5, 1973. </td>
	</tr>
	<tr>
		<td>[Epstein1999]</td>
		<td>Y. Epstein and L. E. Armstrong, \"Fluid-electrolyte balance during labor and exercise: concepts and misconceptions,\" International journal of sport nutrition, vol. 9, pp. 1-12, 1999. </td>
	</tr>
	<tr>
		<td>[Erslev]</td>
		<td>ErslevA. J. Erslev, \"Erythropoietin,\" Leukemia Research, vol. 14, pp. 683-688.</td>
	</tr>
	<tr>
		<td>[Erslev1985]</td>
		<td>A. J. Erslev, J. Caro, and A. Besarab, \"Why the Kidney?,\" Nephron, vol. 41, pp. 213-216, 1985. </td>
	</tr>
	<tr>
		<td>[Erslev1987]</td>
		<td>A. Erslev, J. Wilson, and J. Caro, \"Erythropoietin titers in anemic, nonuremic patients,\" J Lab Clin Med, vol. 109, pp. 429-433, 1987. </td>
	</tr>
	<tr>
		<td>[Erwald1978]</td>
		<td>R. Erwald and K. Wiechel, \"Effect of vasopressin on central and splanchnic hemodynamics in awake man,\" Acta chirurgica Scandinavica, vol. 144, p. 347, 1978. </td>
	</tr>
	<tr>
		<td>[Eschbach1987]</td>
		<td>J. W. Eschbach, J. C. Egrie, M. R. Downing, J. K. Browne, and J. W. Adamson, \"Correction of the Anemia of End-Stage Renal Disease with Recombinant Human Erythropoietin,\" New England Journal of Medicine, vol. 316, pp. 73-78, 1987. </td>
	</tr>
	<tr>
		<td>[Eschbach1989]</td>
		<td>J. W. Eschbach, M. R. Kelly, N. R. Haley, R. I. Abels, and J. W. Adamson, \"Treatment of the Anemia of Progressive Renal Failure with Recombinant Human Erythropoietin,\" New England Journal of Medicine, vol. 321, pp. 158-163, 1989. </td>
	</tr>
	<tr>
		<td>[Eyzaguirre1961]</td>
		<td>C. Eyzaguirre and J. Lewin, \"Chemoreceptor activity of the carotid body of the cat,\" The Journal of Physiology, vol. 159, pp. 222-237, December 1, 1961 1961. </td>
	</tr>
	<tr>
		<td>[Eyzaguirre1961]</td>
		<td>C. Eyzaguirre and J. Lewin, \"The effect of sympathetic stimulation on carotid nerve activity,\" The Journal of Physiology, vol. 159, pp. 251-267, December 1, 1961 1961. </td>
	</tr>
	<tr>
		<td>[Eyzaguirre1965]</td>
		<td>C. Eyzaguirre and H. Koyano, \"Effects of hypoxia, hypercapnia, and pH on the chemoreceptor activity of the carotid body in vitro,\" The Journal of Physiology, vol. 178, pp. 385-409, June 1, 1965 1965. </td>
	</tr>
	<tr>
		<td>[Fan1980]</td>
		<td>F. C. Fan, R. Y. Chen, G. B. Schuessler, and S. Chien, Effects of hematocrit variations on regional hemodynamics and oxygen transport in the dog vol. 238, 1980. </td>
	</tr>
	<tr>
		<td>[Farooqi2002]</td>
		<td>I. S. Farooqi, G. Matarese, G. M. Lord, J. M. Keogh, E. Lawrence, C. Agwu, et al., \"Beneficial effects of leptin on obesity, T cell hyporesponsiveness, and neuroendocrine/metabolic dysfunction of human congenital leptin deficiency,\" The Journal of Clinical Investigation, vol. 110, pp. 1093-1103, 2002. </td>
	</tr>
	<tr>
		<td>[Fatema2002]</td>
		<td>K. Fatema, O. Hirono, Y. Takeishi, J. Nitobe, K. Kaneko, M. Ito, et al., \"Hemodialysis improves myocardial interstitial edema and left ventricular diastolic function in patients with end-stage renal disease: noninvasive assessment by ultrasonic tissue characterization,\" Heart and vessels, vol. 16, pp. 227-231, 2002. </td>
	</tr>
	<tr>
		<td>[Felig1976]</td>
		<td>P. Felig, J. Wahren, R. Sherwin, and R. Hendler, \"The Lilly Lecture 1976: Insulin, Glucagon, and Somatostatin in Normal Physiology and Diabetes Mellitus,\" Diabetes, vol. 25, pp. 1091-1099, December 1, 1976 1976. </td>
	</tr>
	<tr>
		<td>[Felig1976]</td>
		<td>P. Felig, J. Wahren, R. Sherwin, and R. Hendler, \"The Lilly Lecture 1976: Insulin, Glucagon, and Somatostatin in Normal Physiology and Diabetes Mellitus,\" Diabetes, vol. 25, pp. 1091-1099, December 1, 1976 1976. </td>
	</tr>
	<tr>
		<td>[Fenner2008]</td>
		<td>J. W. Fenner, B. Brook, G. Clapworthy, P. Coveney, V. Feipel, H. Gregersen, et al., \"The EuroPhysiome, STEP and a roadmap for the virtual physiological human,\" Philosophical Transactions of the Royal Society A: Mathematical, Physical and Engineering Sciences, vol. 366, pp. 2979-2999, 2008. </td>
	</tr>
	<tr>
		<td>[Ferguson1985]</td>
		<td>D. W. Ferguson, F. M. Abboud, and A. L. Mark, \"Relative contribution of aortic and carotid baroreflexes to heart rate control in man during steady state and dynamic increases in arterial pressure,\" The Journal of Clinical Investigation, vol. 76, pp. 2265-2274, 1985. </td>
	</tr>
	<tr>
		<td>[Ferris1938]</td>
		<td>E. B. Ferris Jr, M. Blankenhorn, H. W. Robinson, and G. E. Cullen, \"Heat stroke: clinical and chemical observations on 44 cases,\" Journal of Clinical Investigation, vol. 17, p. 249, 1938. </td>
	</tr>
	<tr>
		<td>[Field1985]</td>
		<td>M. J. Field and G. J. Giebisch, \"Hormonal control of renal potassium excretion,\" Kidney Int, vol. 27, pp. 379-87, 1985. </td>
	</tr>
	<tr>
		<td>[Figge1991]</td>
		<td>J. Figge, T. H. Rossing, and V. Fencl, \"The role of serum proteins in acid-base equilibria,\" J Lab Clin Med, vol. 117, pp. 453-67, Jun 1991. </td>
	</tr>
	<tr>
		<td>[Findley1937]</td>
		<td>T. Findley, Jr. and H. L. White, \"THE RESPONSE OF NORMAL INDIVIDUALS AND PATIENTS WITH DIABETES INSIPIDUS TO THE INGESTION OF WATER 1,\" The Journal of Clinical Investigation, vol. 16, pp. 197-202, 1937. </td>
	</tr>
	<tr>
		<td>[Fink1975]</td>
		<td>W. J. Fink, D. L. Costill, and P. J. Van Handel, \"Leg muscle metabolism during exercise in the heat and cold,\" European Journal of Applied Physiology and Occupational Physiology, vol. 34, pp. 183-190, 1975/12/01 1975. </td>
	</tr>
	<tr>
		<td>[Fitzgerald1971]</td>
		<td>R. S. Fitzgerald and D. C. Parks, \"Effect of hypoxia on carotid chemoreceptor response to carbon dioxide in cats,\" Respir Physiol, vol. 12, pp. 218-29, Jun 1971. </td>
	</tr>
	<tr>
		<td>[Fitzgerald1971]</td>
		<td>R. S. Fitzgerald and D. C. Parks, \"Effect of hypoxia on carotid chemoreceptor response to carbon dioxide in cats,\" Respir Physiol, vol. 12, pp. 218-29, Jun 1971. </td>
	</tr>
	<tr>
		<td>[FitzGerald1981]</td>
		<td>G. A. FitzGerald, V. Hossmann, and C. T. Dollery, \"Norepinephrine release in essential hypertension,\" Clin. Pharm. Ther., vol. 30, pp. 164-171, 08//print 1981. </td>
	</tr>
	<tr>
		<td>[Fitzgerald1980]</td>
		<td>G. A. Fitzgerald, P. Barnes, C. A. Hamilton, and C. T. Dollery, \"Circulating adrenaline and blood pressure: the metabolic effects and kinetics of infused adrenaline in man,\" European Journal of Clinical Investigation, vol. 10, pp. 401-406, 1980. </td>
	</tr>
	<tr>
		<td>[Fitzgerald1980]</td>
		<td>G. A. Fitzgerald, P. Barnes, C. A. Hamilton, and C. T. Dollery, \"Circulating adrenaline and blood pressure: the metabolic effects and kinetics of infused adrenaline in man,\" European Journal of Clinical Investigation, vol. 10, pp. 401-406, 1980. </td>
	</tr>
	<tr>
		<td>[Flatt1972]</td>
		<td>J. P. Flatt, \"On the Maximal Possible Rate of Ketogenesis,\" Diabetes, vol. 21, pp. 50-53, January 1, 1972 1972. </td>
	</tr>
	<tr>
		<td>[Florez-Duquet1998]</td>
		<td>M. Florez-Duquet and R. B. McDonald, \"Cold-induced thermoregulation and biological aging,\" Physiol Rev, vol. 78, pp. 339-58, Apr 1998. </td>
	</tr>
	<tr>
		<td>[Folkers1969]</td>
		<td>K. Folkers, F. Enzmann, J. Boler, C. Y. Bowers, and A. V. Schally, \"Discovery of modification of the synthetic tripeptide-sequence of the thyrotropin releasing hormone having activity,\" Biochem Biophys Res Commun, vol. 37, pp. 123-6, Sep 24 1969. </td>
	</tr>
	<tr>
		<td>[Forbes1962]</td>
		<td>G. B. Forbes, \"Methods for determining composition of the human body with a note on the effect of diet on body composition,\" Pediatrics, vol. 29, pp. 477-494, 1962. </td>
	</tr>
	<tr>
		<td>[Forbes1956]</td>
		<td>G. B. Forbes and A. M. Lewis, \"Total sodium, potassium and chloride in adult man,\" Journal of Clinical Investigation, vol. 35, p. 596, 1956. </td>
	</tr>
	<tr>
		<td>[Forbes1963]</td>
		<td>G. B. Forbes and J. B. Hursh, \"AGE AND SEX TRENDS IN LEAN BODY MASS CALCULATED FROM K40 MEASUREMENTS: WITH A NOTE ON THE THEORETICAL BASIS FOR THE PROCEDURE*,\" Annals of the New York Academy of Sciences, vol. 110, pp. 255-263, 1963. </td>
	</tr>
	<tr>
		<td>[Forster1971]</td>
		<td>H. V. Forster, J. A. Dempsey, M. L. Birnbaum, W. G. Reddan, J. Thoden, R. F. Grover, et al., Effect of chronic exposure to hypoxia on ventilatory response to CO 2 and hypoxia vol. 31, 1971. </td>
	</tr>
	<tr>
		<td>[Franco-Morselli1977]</td>
		<td>R. Franco-Morselli, J. Elghozi, E. Joly, S. Di Giuilio, and P. Meyer, \"Increased plasma adrenaline concentrations in benign essential hypertension,\" British medical journal, vol. 2, p. 1251, 1977. </td>
	</tr>
	<tr>
		<td>[Frayn2002]</td>
		<td>K. Frayn, \"Adipose tissue as a buffer for daily lipid flux,\" Diabetologia, vol. 45, pp. 1201-1210, 2002. </td>
	</tr>
	<tr>
		<td>[Friedman-Einat2003]</td>
		<td>M. Friedman-Einat, L. Camoin, Z. Faltin, C. Rosenblum, V. Kaliouta, Y. Eshdat, et al., \"Serum leptin activity in obese and lean patients,\" Regulatory peptides, vol. 111, pp. 77-82, 2003. </td>
	</tr>
	<tr>
		<td>[Frisbee2000]</td>
		<td>J. C. Frisbee and J. H. Lombard, \"Increased Intravascular Pressure Does Not Enhance Skeletal Muscle Arteriolar Constriction to Oxygen or Angiotensin II,\" Microvascular Research, vol. 59, pp. 176-180, 1// 2000. </td>
	</tr>
	<tr>
		<td>[Frisbee2000]</td>
		<td>J. C. Frisbee and J. H. Lombard, \"Short-term angiotensin converting enzyme inhibition reduces basal tone and dilator reactivity in skeletal muscle arterioles*,\" American Journal of Hypertension, vol. 13, pp. 389-395, April 1, 2000 2000. </td>
	</tr>
	<tr>
		<td>[Fritzson1998]</td>
		<td>P. Fritzson and V. Engelson, \"Modelica—A unified object-oriented language for system modeling and simulation,\" in ECOOP’98—Object-Oriented Programming, ed: Springer, 1998, pp. 67-90. </td>
	</tr>
	<tr>
		<td>[Gaasch1975]</td>
		<td>W. H. Gaasch, J. S. Cole, M. A. Quinones, and J. Alexander, \"Dynamic determinants of letf ventricular diastolic pressure-volume relations in man,\" Circulation, vol. 51, pp. 317-323, 1975. </td>
	</tr>
	<tr>
		<td>[Ganong1958]</td>
		<td>W. F. Ganong and P. J. Mulrow, \"Rate of Change in Sodium and Potassium Excretion After Injection of Aldosterone Into the Aorta and Renal Artery of the Dog’,\" change, vol. 7, p. 90, 1958. </td>
	</tr>
	<tr>
		<td>[Garlick1970]</td>
		<td>D. Garlick and E. Renkin, Transport of large molecules from plasma to interstitial fluid and lymph in dogs vol. 219, 1970. </td>
	</tr>
	<tr>
		<td>[GAUER1956]</td>
		<td>O. H. GAUER, J. P. HENRY, and H. O. SIEKER, \"Changes in Central Venous Pressure after Moderate Hemorrhage and Transfusion in Man,\" Circulation Research, vol. 4, pp. 79-84, January 1, 1956 1956. </td>
	</tr>
	<tr>
		<td>[Gauss1917]</td>
		<td>H. Gauss and K. Meyer, \"HEAT STROKE: REPORT OF ONE HUNDRED AND FIFTY-EIGHT CASES FROM COOK COUNTY HOSPITAL, CHICAGO,\" The American Journal of the Medical Sciences, vol. 154, p. 554, 1917. </td>
	</tr>
	<tr>
		<td>[Gautron2011]</td>
		<td>L. Gautron and J. K. Elmquist, \"Sixteen years and counting: an update on leptin in energy balance,\" The Journal of Clinical Investigation, vol. 121, pp. 2087-2093, 2011. </td>
	</tr>
	<tr>
		<td>[Gekle1998]</td>
		<td>M. Gekle, Renal Proximal Tubular Albumin Reabsorption: Daily Prevention of Albuminuria vol. 13, 1998. </td>
	</tr>
	<tr>
		<td>[George2004]</td>
		<td>S. George, J. J. Rochford, C. Wolfrum, S. L. Gray, S. Schinner, J. C. Wilson, et al., \"A family with severe insulin resistance and diabetes due to a mutation in AKT2,\" Science, vol. 304, pp. 1325-1328, 2004. </td>
	</tr>
	<tr>
		<td>[Gephart1915]</td>
		<td>F. C. Gephart and E. F. DuBOIS, \"FOURTH PAPER THE DETERMINATION OF THE BASAL METABOLISM OF NORMAL MEN AND THE EFFECT OF FOOD,\" Archives of Internal Medicine, vol. 15, pp. 835-867, 1915. </td>
	</tr>
	<tr>
		<td>[Gerich1975]</td>
		<td>J. E. Gerich, M. Lorenzi, D. M. Bier, V. Schneider, E. Tsalikian, J. H. Karam, et al., \"Prevention of human diabetic ketoacidosis by somatostatin: evidence for an essential role of glucagon,\" New England Journal of Medicine, vol. 292, pp. 985-989, 1975. </td>
	</tr>
	<tr>
		<td>[Gerich1975]</td>
		<td>J. E. Gerich, M. Lorenzi, D. M. Bier, V. Schneider, E. Tsalikian, J. H. Karam, et al., \"Prevention of Human Diabetic Ketoacidosis by Somatostatin,\" New England Journal of Medicine, vol. 292, pp. 985-989, 1975. </td>
	</tr>
	<tr>
		<td>[Ghazanshahi1993]</td>
		<td>S. Ghazanshahi and M. K. Khoo, \"Optimal ventilatory patterns in periodic breathing,\" Annals of Biomedical Engineering, vol. 21, pp. 517-530, 1993/09/01 1993. </td>
	</tr>
	<tr>
		<td>[Gibbs1942]</td>
		<td>E. L. Gibbs, F. A. Gibbs, W. G. Lennox, and L. F. Nims, \"REgulation of cerebral carbon dioxide,\" Archives of Neurology & Psychiatry, vol. 47, pp. 879-889, 1942. </td>
	</tr>
	<tr>
		<td>[GINSBERG1973]</td>
		<td>S. GINSBERG, M. B. BLOCK, M. E. MAKO, and A. H. RUBENSTEIN, \"Serum Insulin Levels Following Administration of Exogenous Insulin,\" The Journal of Clinical Endocrinology & Metabolism, vol. 36, pp. 1175-1179, 1973. </td>
	</tr>
	<tr>
		<td>[Glickson1974]</td>
		<td>J. D. Glickson and C. Pissiotis, Vasopressin: Chemical and clinical aspects vol. 1: Ardent Media, 1974. </td>
	</tr>
	<tr>
		<td>[Gold1940]</td>
		<td>H. Gold and M. Cattell, \"MEchanism of digitalis action in abolishing heart failure,\" Archives of Internal Medicine, vol. 65, pp. 263-278, 1940. </td>
	</tr>
	<tr>
		<td>[Goldberg1994]</td>
		<td>M. A. Goldberg and T. J. Schneider, \"Similarities between the oxygen-sensing mechanisms regulating the expression of vascular endothelial growth factor and erythropoietin,\" Journal of Biological Chemistry, vol. 269, pp. 4355-9, February 11, 1994 1994. </td>
	</tr>
	<tr>
		<td>[Goldstein2003]</td>
		<td>D. S. Goldstein, G. Eisenhofer, and I. J. Kopin, \"Sources and Significance of Plasma Levels of Catechols and Their Metabolites in Humans,\" Journal of Pharmacology and Experimental Therapeutics, vol. 305, pp. 800-811, June 1, 2003 2003. </td>
	</tr>
	<tr>
		<td>[Goldstein1987]</td>
		<td>S. Goldstein, J. Askanazi, C. Weissman, B. Thomashow, and J. Kinney, \"Energy expenditure in patients with chronic obstructive pulmonary disease,\" CHEST Journal, vol. 91, pp. 222-224, 1987. </td>
	</tr>
	<tr>
		<td>[Good1984]</td>
		<td>D. W. Good, H. Velazquez, and F. S. Wright, \"Luminal influences on potassium secretion: low sodium concentration,\" Am J Physiol, vol. 246, p. 20, 1984. </td>
	</tr>
	<tr>
		<td>[Goodman1978]</td>
		<td>A. H. Goodman, R. Einstein, and H. J. Granger, \"Effect of changing metabolic rate on local blood flow control in the canine hindlimb,\" Circulation Research, vol. 43, pp. 769-76, November 1, 1978 1978. </td>
	</tr>
	<tr>
		<td>[Gottschalk1959]</td>
		<td>C. W. Gottschalk and M. Mylle, \"Micropuncture study of the mammalian urinary concentrating mechanism: evidence for the countercurrent hypothesis,\" American Journal of Physiology--Legacy Content, vol. 196, pp. 927-936, 1959. </td>
	</tr>
	<tr>
		<td>[Gottschalk1960]</td>
		<td>C. W. Gottschalk, W. E. Lassiter, and M. Mylle, Localization of urine acidification in the mammalian kidney vol. 198, 1960. </td>
	</tr>
	<tr>
		<td>[Granger1969]</td>
		<td>H. J. Granger and A. C. Guyton, \"Autoregulation of the Total Systemic Circulation Following Destruction of the Central Nervous System in the Dog,\" Circulation Research, vol. 25, pp. 379-388, October 1, 1969 1969. </td>
	</tr>
	<tr>
		<td>[Granger1983]</td>
		<td>D. N. Granger and H. J. Granger, \"Systems analysis of intestinal hemodynamics and oxygenation,\" Am J Physiol, vol. 245, pp. G786-G796, 1983. </td>
	</tr>
	<tr>
		<td>[Granger1976]</td>
		<td>H. J. Granger, A. H. Goodman, and D. N. Granger, \"Role of resistance and exchange vessels in local microvascular control of skeletal muscle oxygenation in the dog,\" Circulation Research, vol. 38, pp. 379-85, May 1, 1976 1976. </td>
	</tr>
	<tr>
		<td>[Granger1980]</td>
		<td>D. N. Granger, N. A. Mortillaro, P. R. Kvietys, G. Rutili, J. C. Parker, and A. E. Taylor, Role of the interstitial matrix during intestinal volume absorption vol. 238, 1980. </td>
	</tr>
	<tr>
		<td>[Greenway1973]</td>
		<td>C. Greenway and G. Oshiro, \"Effects of histamine on hepatic volume (outflow block) in anaesthetized dogs,\" British journal of pharmacology, vol. 47, pp. 282-290, 1973. </td>
	</tr>
	<tr>
		<td>[Greenway1974]</td>
		<td>C. V. Greenway and G. E. Lister, \"Capacitance effects and blood reservoir function in the splanchnic vascular bed during non-hypotensive haemorrhage and blood volume expansion in anaesthetized cats,\" The Journal of Physiology, vol. 237, pp. 279-294, March 1, 1974 1974. </td>
	</tr>
	<tr>
		<td>[Greenway1985]</td>
		<td>C. V. Greenway, K. L. Seaman, and I. R. Innes, Norepinephrine on venous compliance and unstressed volume in cat liver vol. 248, 1985. </td>
	</tr>
	<tr>
		<td>[Grimm1980]</td>
		<td>M. Grimm, P. Weidmann, G. Keusch, A. Meier, and Z. Glück, \"Norepinephrine clearance and pressor effect in normal and hypertensive man,\" Klinische Wochenschrift, vol. 58, pp. 1175-1181, 1980. </td>
	</tr>
	<tr>
		<td>[Gross1952]</td>
		<td>J. Gross and R. Pitt-Rivers, \"The identification of 3:5:3'-L-triiodothyronine in human plasma,\" Lancet, vol. 1, pp. 439-41, Mar 1 1952. </td>
	</tr>
	<tr>
		<td>[Gross1953]</td>
		<td>J. Gross and R. Pitt-Rivers, \"3: 5: 3'-Triiodothyronine. 1. Isolation from thyroid gland and synthesis,\" Biochemical Journal, vol. 53, p. 645, 1953. </td>
	</tr>
	<tr>
		<td>[Gross1953]</td>
		<td>J. Gross and R. Pitt-Rivers, \"3: 5: 3'-Triiodothyronine. 2. Physiological activity,\" Biochemical Journal, vol. 53, p. 652, 1953. </td>
	</tr>
	<tr>
		<td>[Guarente2009]</td>
		<td>L. Guarente, \"Hypoxic Hookup,\" Science, vol. 324, pp. 1281-1282, June 5, 2009 2009. </td>
	</tr>
	<tr>
		<td>[Guggino1989]</td>
		<td>W. B. Guggino and S. E. Guggino, \"Renal anion transport,\" Kidney Int, vol. 36, pp. 385-391, 09//print 1989. </td>
	</tr>
	<tr>
		<td>[Gullans1985]</td>
		<td>S. R. Gullans, M. J. Avison, T. Ogino, G. Giebisch, and R. G. Shulman, \"NMR measurements of intracellular sodium in the rabbit proximal tubule,\" Am. J. Physiol, vol. 249, pp. F160-F168, 1985. </td>
	</tr>
	<tr>
		<td>[Gutsche1980]</td>
		<td>H. U. Gutsche, R. Müller-Suur, U. Hegel, and K. Hierholzer, \"Electrical conductivity of tubular fluid of the rat nephron,\" Pflügers Archiv, vol. 383, pp. 113-121, 1980/01/01 1980. </td>
	</tr>
	<tr>
		<td>[Guyton1965]</td>
		<td>A. C. Guyton, \"Interstitial fluid pressure: II. Pressure-volume curves of interstitial space,\" Circulation research, vol. 16, pp. 452-460, 1965. </td>
	</tr>
	<tr>
		<td>[Guyton1961]</td>
		<td>A. C. Guyton and K. Sagawa, \"Compensations of cardiac output and other circulatory functions in areflex dogs with large AV fistulas,\" The American journal of physiology, vol. 200, p. 1157, 1961. </td>
	</tr>
	<tr>
		<td>[Guyton1972]</td>
		<td>A. C. Guyton, T. G. Coleman, and H. J. Granger, \"Circulation: overall regulation,\" Annual Review of Physiology, vol. 34, pp. 13-44, 1972. </td>
	</tr>
	<tr>
		<td>[Guyton1978]</td>
		<td>J. R. Guyton, R. O. Foster, J. S. Soeldner, M. H. Tan, C. B. Kahn, L. Koncz, et al., \"A Model of Glucose-insulin Homeostasis in Man that Incorporates the Heterogeneous Fast Pool Theory of Pancreatic Insulin Release,\" Diabetes, vol. 27, pp. 1027-1042, October 1, 1978 1978. </td>
	</tr>
	<tr>
		<td>[Hakkinen1995]</td>
		<td>J. P. Hakkinen, M. W. Miller, A. H. Smith, and D. R. Knight, \"Measurement of organ blood flow with coloured microspheres in the rat,\" Cardiovascular research, vol. 29, pp. 74-79, 1995. </td>
	</tr>
	<tr>
		<td>[Halaas1997]</td>
		<td>J. L. Halaas, C. Boozer, J. Blair-West, N. Fidahusein, D. A. Denton, and J. M. Friedman, \"Physiological response to long-term peripheral and central leptin infusion in lean and obese?mice,\" Proceedings of the National Academy of Sciences, vol. 94, pp. 8878-8883, August 5, 1997 1997. </td>
	</tr>
	<tr>
		<td>[Hall1986]</td>
		<td>J. E. Hall, \"Control of sodium excretion by angiotensin II: intrarenal mechanisms and blood pressure regulation,\" 1986. </td>
	</tr>
	<tr>
		<td>[Hall1983]</td>
		<td>J. E. Hall and J. P. Granger, Renal hemodynamic actions of angiotensin II: interaction with tubuloglomerular feedback vol. 245, 1983. </td>
	</tr>
	<tr>
		<td>[Hall1979]</td>
		<td>J. Hall, T. Coleman, A. Guyton, J. Balfe, and H. Salgado, \"Intrarenal role of angiotensin II and </td>
	</tr>
	<tr>
		<td>[des-Asp1]</td>
		<td>1977]	J. E. Hall, A. C. Guyton, N. C. Trippodo, T. E. Lohmeier, R. McCaa, and A. Cowley Jr, \"Intrarenal control of electrolyte excretion by angiotensin II,\" Am J Physiol, vol. 232, pp. F538-F544, 1977. </td>
	</tr>
	<tr>
		<td>[Hall1977]</td>
		<td>J. E. Hall, A. C. Guyton, T. E. Jackson, T. G. Coleman, T. E. Lohmeier, and N. C. Trippodo, \"Control of glomerular filtration rate by renin-angiotensin system,\" Am J Physiol, vol. 233, pp. F366-F372, 1977. </td>
	</tr>
	<tr>
		<td>[Halperin1989]</td>
		<td>M. L. Halperin and S. Cheema-Dhadli, \"Renal and hepatic aspects of ketoacidosis: A quantitative analysis based on energy turnover,\" Diabetes/Metabolism Reviews, vol. 5, pp. 321-336, 1989. </td>
	</tr>
	<tr>
		<td>[Hannaford1982]</td>
		<td>M. C. Hannaford, L. A. Leiter, R. G. Josse, M. B. Goldstein, E. B. Marliss, and M. L. Halperin, Protein wasting due to acidosis of prolonged fasting vol. 243, 1982. </td>
	</tr>
	<tr>
		<td>[HANNON1969]</td>
		<td>R. C. HANNON, R. P. DERUYCK, J. V. JOOSSENS, and A. K. AMERY, \"Disappearance rate of endogenous renin from the plasma after bilateral nephrectomy in humans,\" The Journal of Clinical Endocrinology & Metabolism, vol. 29, pp. 1420-1424, 1969. </td>
	</tr>
	<tr>
		<td>[Harder1996]</td>
		<td>D. R. Harder, J. Narayanan, E. K. Birks, J. F. Liard, J. D. Imig, J. H. Lombard, et al., \"Identification of a Putative Microvascular Oxygen Sensor,\" Circulation Research, vol. 79, pp. 54-61, July 1, 1996 1996. </td>
	</tr>
	<tr>
		<td>[Harder1996]</td>
		<td>D. R. Harder, J. Narayanan, E. K. Birks, J. F. Liard, J. D. Imig, J. H. Lombard, et al., \"Identification of a Putative Microvascular Oxygen Sensor,\" Circulation Research, vol. 79, pp. 54-61, July 1, 1996 1996. </td>
	</tr>
	<tr>
		<td>[Hardy1961]</td>
		<td>J. D. Har" + "dy, \"Physiology of temperature regulation,\" Physiol Rev, vol. 41, pp. 521-606, Jul 1961. </td>
	</tr>
	<tr>
		<td>[Hardy1938]</td>
		<td>J. D. Hardy and G. F. Soderstrom, \"Heat Loss from the Nude Body and Peripheral Blood Flow at Temperatures of 22°C. to 35°C.: Two Figures,\" The Journal of Nutrition, vol. 16, pp. 493-510, November 1, 1938 1938. </td>
	</tr>
	<tr>
		<td>[Harrison1938]</td>
		<td>H. E. Harrison and D. C. Darrow, \"The distribution of body water and electrolytes in adrenal insufficiency,\" Journal of Clinical Investigation, vol. 17, p. 77, 1938. </td>
	</tr>
	<tr>
		<td>[Harrop1923]</td>
		<td>G. A. Harrop and E. M. Benedict, \"The role of phosphate and potassium in carbohydrate metabolism following insulin administration,\" Experimental Biology and Medicine, vol. 20, pp. 430-431, May 1, 1923 1923. </td>
	</tr>
	<tr>
		<td>[HART1982]</td>
		<td>G. R. HART, R. J. ANDERSON, C. P. CRUMPLER, A. SHULKIN, G. REED, and J. P. KNOCHEL, \"Epidemic classical heat stroke: clinical characteristics and course of 28 patients,\" Medicine, vol. 61, p. 189, 1982. </td>
	</tr>
	<tr>
		<td>[Hatcher1978]</td>
		<td>J. D. Hatcher, L. K. Chiu, and D. B. Jennings, Anemia as a stimulus to aortic and carotid chemoreceptors in the cat vol. 44, 1978. </td>
	</tr>
	<tr>
		<td>[Havel2004]</td>
		<td>P. J. Havel, \"Update on adipocyte hormones regulation of energy balance and carbohydrate/lipid metabolism,\" Diabetes, vol. 53, pp. S143-S151, 2004. </td>
	</tr>
	<tr>
		<td>[HAYS1993]</td>
		<td>M. T. HAYS, \"Colonic excretion of iodide in normal human subjects,\" Thyroid, vol. 3, pp. 31-35, 1993. </td>
	</tr>
	<tr>
		<td>[Hayward1993]</td>
		<td>L. Hayward, M. Hay, and R. Felder, \"Acute resetting of the carotid sinus baroreflex by aortic depressor nerve stimulation,\" METHODS, vol. 10, p. 11, 1993. </td>
	</tr>
	<tr>
		<td>[Heller1932]</td>
		<td>H. Heller and F. H. Smirk, \"Studies concerning the alimentary absorption of water and tissue hydration in relation to diuresis,\" The Journal of Physiology, vol. 76, pp. 1-38, September 16, 1932 1932. </td>
	</tr>
	<tr>
		<td>[Hennessy1993]</td>
		<td>E. Hennessy, S. White, T. Van der Touw, A. Quail, W. Porges, and P. Glenfield, \"Control of resting bronchial hemodynamics in the awake dog,\" American Journal of Physiology, vol. 265, pp. H649-H649, 1993. </td>
	</tr>
	<tr>
		<td>[Henriksen1985]</td>
		<td>J. H. Henriksen, \"Estimation of lymphatic conductance: A model based on protein-kinetic studies and haemodynamic measurements in patients with cirrhosis of the liver and in pigs,\" Scandinavian journal of clinical & laboratory investigation, vol. 45, pp. 123-130, 1985. </td>
	</tr>
	<tr>
		<td>[Henriksen1985]</td>
		<td>J. H. Henriksen, \"Estimation of lymphatic conductance,\" Scandinavian Journal of Clinical & Laboratory Investigation, vol. 45, pp. 123-130, 1985. </td>
	</tr>
	<tr>
		<td>[Henry1950]</td>
		<td>J. P. Henry and O. H. Gauer, \"THE INFLUENCE OF TEMPERATURE UPON VENOUS PRESSURE IN THE FOOT,\" The Journal of Clinical Investigation, vol. 29, pp. 855-861, 1950. </td>
	</tr>
	<tr>
		<td>[HENSEL1953]</td>
		<td>H. HENSEL, \"The time factor in thermoreceptor excitation,\" Acta Physiologica Scandinavica, vol. 29, pp. 109-116, 1953. </td>
	</tr>
	<tr>
		<td>[Hermansson1981]</td>
		<td>K. Hermansson, M. Larson, Ö. Källskog, and M. Wolgast, \"Influence of renal nerve activity on arteriolar resistance, ultrafiltration dynamics and fluid reabsorption,\" Pflügers Archiv, vol. 389, pp. 85-90, 1981/01/01 1981. </td>
	</tr>
	<tr>
		<td>[Hesslink1992]</td>
		<td>R. L. Hesslink, M. M. D'Alesandro, D. W. Armstrong, and H. L. Reed, Human cold air habituation is independent of thyroxine and thyrotropin vol. 72, 1992. </td>
	</tr>
	<tr>
		<td>[Hester2010]</td>
		<td>R. Hester, R. Summers, R. Iliescu, and T. Coleman, \"HumMod: An integrative model of integrative biomedicine,\" in The Interservice/Industry Training, Simulation & Education Conference (I/ITSEC), 2010. </td>
	</tr>
	<tr>
		<td>[Hester2011]</td>
		<td>R. L. Hester, R. Iliescu, R. Summers, and T. G. Coleman, \"Systems biology and integrative physiological modelling,\" The Journal of physiology, vol. 589, pp. 1053-1060, 2011. </td>
	</tr>
	<tr>
		<td>[Hester2011]</td>
		<td>R. L. Hester, A. J. Brown, L. Husband, R. Iliescu, D. Pruett, R. Summers, et al., \"HumMod: a modeling environment for the simulation of integrative human physiology,\" Frontiers in Physiology, vol. 2, 2011. </td>
	</tr>
	<tr>
		<td>[Heyeraas1987]</td>
		<td>K. J. Heyeraas and K. Aukland, \"Interlobular arterial resistance: Influence of renal arterial pressure and angiotensin II,\" Kidney Int, vol. 31, pp. 1291-1298, 06//print 1987. </td>
	</tr>
	<tr>
		<td>[Heyndrickx1976]</td>
		<td>G. Heyndrickx, D. H. Boettcher, and S. F. Vatner, \"Effects of angiotensin, vasopressin, and methoxamine on cardiac function and blood flow distribution in conscious dogs,\" Am J Physiol, vol. 231, pp. 1579-1587, 1976. </td>
	</tr>
	<tr>
		<td>[Higgins1975]</td>
		<td>H. P. Higgins, J. M. Hershman, J. G. Kenimer, R. A. Patillo, T. A. Bayley, and P. Walfish, \"The Thyrotoxicosis of Hydatidiform Mole,\" Annals of Internal Medicine, vol. 83, pp. 307-311, 1975. </td>
	</tr>
	<tr>
		<td>[Hogan1990]</td>
		<td>M. C. Hogan, D. E. Bebout, A. T. Gray, P. D. Wagner, J. B. West, and P. E. Haab, Muscle maximal O2 uptake at constant O2 delivery with and without CO in the blood vol. 69, 1990. </td>
	</tr>
	<tr>
		<td>[HOLLENBERG1975]</td>
		<td>N. K. HOLLENBERG, D. F. ADAMS, H. SOLOMON, W. R. CHENITZ, B. M. BURGER, H. L. ABRAMS, et al., \"RENAL VASCULAR TONE IN ESSENTIAL AND SECONDARY HYPERTENSION: HEMODYNAMIC AND ANGIOGRAPHIC RESPONSES TO VASODILATORS,\" Medicine, vol. 54, pp. 29-44, 1975. </td>
	</tr>
	<tr>
		<td>[Hollifield1981]</td>
		<td>J. W. Hollifield and P. E. Slaton, \"Thiazide diuretics, hypokalemia and cardiac arrhythmias,\" Acta Medica Scandinavica, vol. 209, pp. 67-73, 1981. </td>
	</tr>
	<tr>
		<td>[Hollifield1981]</td>
		<td>J. W. Hollifield and P. E. Slaton, \"Thiazide diuretics, hypokalemia and cardiac arrhythmias,\" Acta Medica Scandinavica, vol. 209, pp. 67-73, 1981. </td>
	</tr>
	<tr>
		<td>[Hood1983]</td>
		<td>V. L. Hood and R. L. Tannen, \"pH control of lactic acid and keto acid production: a mechanism of acid-base regulation,\" Miner Electrolyte Metab, vol. 9, pp. 317-25, 1983. </td>
	</tr>
	<tr>
		<td>[Hornbein1963]</td>
		<td>T. F. Hornbein and A. Roos, Specificity of H ion concentration as a carotid chemoreceptor stimulus vol. 18, 1963. </td>
	</tr>
	<tr>
		<td>[Hornbein1961]</td>
		<td>T. F. Hornbein, Z. J. Griffo, and A. Roos, QUANTITATION OF CHEMORECEPTOR ACTIVITY: INTERRELATION OF HYPOXIA AND HYPERCAPNIA vol. 24, 1961. </td>
	</tr>
	<tr>
		<td>[Horowitz2003]</td>
		<td>M. Horowitz, \"Matching the heart to heat-induced circulatory load: heat-acclimatory responses,\" Physiology, vol. 18, pp. 215-221, 2003. </td>
	</tr>
	<tr>
		<td>[Horvath1956]</td>
		<td>S. M. Horvath, G. B. Spurr, B. K. Hutt, and L. H. Hamilton, Metabolic Cost of Shivering vol. 8, 1956. </td>
	</tr>
	<tr>
		<td>[Horwitz1977]</td>
		<td>L. D. Horwitz, J. M. Atkins, and M. Saito, \"Effect of digitalis on left ventricular function in exercising dogs,\" Circulation research, vol. 41, pp. 744-750, 1977. </td>
	</tr>
	<tr>
		<td>[Hsieh1965]</td>
		<td>A. C. L. Hsieh, T. Nagasaka, and L. D. Carlson, Effects of immersion of the hand in cold water on digital blood flow vol. 20, 1965. </td>
	</tr>
	<tr>
		<td>[Hucka2003]</td>
		<td>M. Hucka, A. Finney, H. M. Sauro, H. Bolouri, J. C. Doyle, H. Kitano, et al., \"The systems biology markup language (SBML): a medium for representation and exchange of biochemical network models,\" Bioinformatics, vol. 19, pp. 524-531, 2003. </td>
	</tr>
	<tr>
		<td>[Hucka2004]</td>
		<td>M. Hucka, A. Finney, B. J. Bornstein, S. M. Keating, B. E. Shapiro, J. Matthews, et al., \"Evolving a lingua franca and associated software infrastructure for computational systems biology: the Systems Biology Markup Language (SBML) project,\" Systems biology, vol. 1, pp. 41-53, 2004. </td>
	</tr>
	<tr>
		<td>[Hunter2003]</td>
		<td>P. J. Hunter and T. K. Borg, \"Integration from proteins to organs: the Physiome Project,\" Nature Reviews Molecular Cell Biology, vol. 4, pp. 237-243, 2003. </td>
	</tr>
	<tr>
		<td>[Hunter2009]</td>
		<td>P. J. Hunter and M. Viceconti, \"The VPH-physiome project: standards and tools for multiscale modeling in clinical applications,\" Biomedical Engineering, IEEE Reviews in, vol. 2, pp. 40-53, 2009. </td>
	</tr>
	<tr>
		<td>[Hunter2002]</td>
		<td>P. Hunter, P. Robbins, and D. Noble, \"The IUPS human physiome project,\" Pflügers Archiv, vol. 445, pp. 1-9, 2002. </td>
	</tr>
	<tr>
		<td>[Hunter2008]</td>
		<td>P. J. Hunter, E. J. Crampin, and P. M. Nielsen, \"Bioinformatics, multiscale modeling and the IUPS Physiome Project,\" Briefings in bioinformatics, vol. 9, pp. 333-343, 2008. </td>
	</tr>
	<tr>
		<td>[Hunter2006]</td>
		<td>P. J. Hunter, W. W. Li, A. D. McCulloch, and D. Noble, \"Multiscale modeling: Physiome project standards, tools, and databases,\" Computer, vol. 39, pp. 48-54, 2006. </td>
	</tr>
	<tr>
		<td>[Huth1959]</td>
		<td>E. Huth, R. Squires, and J. Elkinton, \"Experimental potassium depletion in normal human subjects. II. Renal and hormonal factors in the development of extracellular alkalosis during depletion,\" Journal of Clinical Investigation, vol. 38, p. 1149, 1959. </td>
	</tr>
	<tr>
		<td>[Charan1984]</td>
		<td>N. B. Charan, G. M. Turk, and R. Dhand, \"Gross and subgross anatomy of bronchial circulation in sheep,\" J Appl Physiol, vol. 57, pp. 658-664, 1984. </td>
	</tr>
	<tr>
		<td>[Charles1994]</td>
		<td>J. B. Charles and C. M. Lathers, \"Summary of Lower Body Negative Pressure Experiments During Space Flight,\" The Journal of Clinical Pharmacology, vol. 34, pp. 571-583, 1994. </td>
	</tr>
	<tr>
		<td>[Chen2004]</td>
		<td>M. Chen, M. Haluzik, N. J. Wolf, J. Lorenzo, K. R. Dietz, M. L. Reitman, et al., \"Increased insulin sensitivity in paternal Gnas knockout mice is associated with increased lipid clearance,\" Endocrinology, vol. 145, pp. 4094-4102, 2004. </td>
	</tr>
	<tr>
		<td>[Cherrington1987]</td>
		<td>A. Cherrington, R. Stevenson, K. Steiner, M. Davis, S. Myers, B. Adkins, et al., \"Insulin, glucagon, and glucose as regulators of hepatic glucose uptake and production in vivo,\" Diabetes/metabolism reviews, vol. 3, pp. 307-332, 1987. </td>
	</tr>
	<tr>
		<td>[Chiasson1976]</td>
		<td>J. Chiasson, J. Liljenquist, F. Finger, and W. Lacy, \"Differential sensitivity of glycogenolysis and gluconeogenesis to insulin infusions in dogs,\" Diabetes, vol. 25, pp. 283-291, 1976. </td>
	</tr>
	<tr>
		<td>[Chopra1976]</td>
		<td>I. J. Chopra, \"An assessment of daily production and significance of thyroidal secretion of 3, 3', 5'-triiodothyronine (reverse T3) in man,\" The Journal of Clinical Investigation, vol. 58, pp. 32-40, 1976. </td>
	</tr>
	<tr>
		<td>[CHOPRA1975]</td>
		<td>I. J. CHOPRA, J. M. HERSHMAN, and R. W. HORNABROOK, \"Serum Thyroid Hormone and Thyrotropin Levels in Subjects from Endemic Goiter Regions of New Guinea,\" The Journal of Clinical Endocrinology & Metabolism, vol. 40, pp. 326-333, 1975. </td>
	</tr>
	<tr>
		<td>[Christie1934]</td>
		<td>R. V. Christie and C. A. McIntosh, \"THE MEASUREMENT OF THE INTRAPLEURAL PRESSURE IN MAN AND ITS SIGNIFICANCE,\" The Journal of Clinical Investigation, vol. 13, pp. 279-294, 1934. </td>
	</tr>
	<tr>
		<td>[Christlieb1968]</td>
		<td>A. R. Christlieb, N. P. Couch, E. A. Amsterdam, S. J. Dobrzinsky, and R. B. Hickler, \"Renin extraction by the human liver,\" Experimental Biology and Medicine, vol. 128, pp. 821-823, 1968. </td>
	</tr>
	<tr>
		<td>[Iampietro1960]</td>
		<td>P. F. Iampietro, J. A. Vaughan, R. F. Goldman, M. B. Kreider, F. Masucci, and D. E. Bass, Heat production from shivering vol. 15, 1960. </td>
	</tr>
	<tr>
		<td>[Ibsen1980]</td>
		<td>H. Ibsen, N. J. Christensen, H. Hollnagel, A. Leth, A. M. Kappelgaard, and J. Giese, \"Plasma noradrenaline concentration in hypertensive and normotensive forty-year-old individuals: Relationship to plasma renin concentration,\" Scandinavian Journal of Clinical & Laboratory Investigation, vol. 40, pp. 333-339, 1980. </td>
	</tr>
	<tr>
		<td>[Ichihara1997]</td>
		<td>A. Ichihara, E. W. Inscho, J. D. Imig, R. E. Michel, and L. G. Navar, \"Role of Renal Nerves in Afferent Arteriolar Reactivity in Angiotensin-Induced Hypertension,\" Hypertension, vol. 29, pp. 442-449, January 1, 1997 1997. </td>
	</tr>
	<tr>
		<td>[Ikeda1979]</td>
		<td>N. Ikeda, F. Marumo, M. Shirataka, and T. Sato, \"A model of overall regulation of body fluids,\" Annals of biomedical engineering, vol. 7, pp. 135-166, 1979. </td>
	</tr>
	<tr>
		<td>[Imai2008]</td>
		<td>J. Imai, H. Katagiri, T. Yamada, Y. Ishigaki, T. Suzuki, H. Kudo, et al., \"Regulation of Pancreatic ß Cell Mass by Neuronal Signals from the Liver,\" Science, vol. 322, pp. 1250-1254, November 21, 2008 2008. </td>
	</tr>
	<tr>
		<td>[Imaizumi1993]</td>
		<td>T. Imaizumi, M. Sugimachi, Y. Harasawa, S. Ando, K. Sunagawa, Y. Hirooka, et al., \"Contribution of wall mechanics to the dynamic properties of aortic baroreceptors,\" American Journal of Physiology-Heart and Circulatory Physiology, vol. 264, pp. H872-H880, 1993. </td>
	</tr>
	<tr>
		<td>[Issekutz1964]</td>
		<td>B. Issekutz, H. I. Miller, P. Paul, and K. Rodahl, Source of fat oxidation in exercising dogs vol. 207, 1964. </td>
	</tr>
	<tr>
		<td>[Ito1990]</td>
		<td>S. Ito and O. A. Carretero, \"An in vitro approach to the study of macula densa-mediated glomerular hemodynamics,\" Kidney Int, vol. 38, pp. 1206-10, Dec 1990. </td>
	</tr>
	<tr>
		<td>[Ito1992]</td>
		<td>S. Ito, O. A. Carretero, K. Abe, L. A. Juncos, and K. Yoshinaga, \"Macula Densa Control of Renin Release and Glomerular Hemodynamics,\" The Tohoku Journal of Experimental Medicine, vol. 166, pp. 27-39, 1992. </td>
	</tr>
	<tr>
		<td>[Itoh1985]</td>
		<td>S. Itoh and O. A. Carretero, \"Role of the macula densa in renin release,\" Hypertension, vol. 7, p. I49, 1985. </td>
	</tr>
	<tr>
		<td>[Iwanishi2000]</td>
		<td>M. Iwanishi, M. P. Czech, and A. D. Cherniack, \"The Protein-tyrosine Kinase Fer Associates with Signaling Complexes Containing Insulin Receptor Substrate-1 and Phosphatidylinositol 3-Kinase,\" Journal of Biological Chemistry, vol. 275, pp. 38995-39000, December 15, 2000 2000. </td>
	</tr>
	<tr>
		<td>[Jackson1982]</td>
		<td>I. M. D. Jackson, \"Thyrotropin-Releasing Hormone,\" New England Journal of Medicine, vol. 306, pp. 145-155, 1982. </td>
	</tr>
	<tr>
		<td>[Jacobson1957]</td>
		<td>L. O. Jacobson, E. Goldwasser, W. Fried, and L. Plzak, \"Role of the Kidney in Erythropoiesis,\" Nature, vol. 179, pp. 633-634, 03/23/print 1957. </td>
	</tr>
	<tr>
		<td>[Jamison1972]</td>
		<td>R. Jamison and F. B. Lacy, \"Evidence for urinary dilution by the collecting tubule,\" Am. J. Physiol, vol. 223, pp. 898-902, 1972. </td>
	</tr>
	<tr>
		<td>[Jamison1971]</td>
		<td>R. L. Jamison, J. Buerkert, F. Lacy, D. Marcus, and B. Henton, \"A micropuncture study of collecting tubule function in rats with hereditary diabetes insipidus,\" Journal of Clinical Investigation, vol. 50, p. 2444, 1971. </td>
	</tr>
	<tr>
		<td>[Jan1977]</td>
		<td>K. M. Jan and S. Chien, Effect of hematocrit variations on coronary hemodynamics and oxygen utilization vol. 233, 1977. </td>
	</tr>
	<tr>
		<td>[Jans1987]</td>
		<td>A. W. Jans, K. Amsler, B. Griewel, and R. K. Kinne, \"Regulation of intracellular pH in LLC-PK< sub> 1</sub> cells studied using< sup> 31</sup> P-NMR spectroscopy,\" Biochimica et Biophysica Acta (BBA)-Molecular Cell Research, vol. 927, pp. 203-212, 1987. </td>
	</tr>
	<tr>
		<td>[Jaspan1981]</td>
		<td>J. Jaspan, K. Polonsky, M. Lewis, J. Pensler, W. Pugh, A. Moossa, et al., \"Hepatic metabolism of glucagon in the dog: contribution of the liver to overall metabolic disposal of glucagon,\" Am J Physiol, vol. 240, pp. E233-E244, 1981. </td>
	</tr>
	<tr>
		<td>[Jelinek1993]</td>
		<td>L. J. Jelinek, S. Lok, G. B. Rosenberg, R. A. Smith, F. J. Grant, S. Biggs, et al., \"Expression cloning and signaling properties of the rat glucagon receptor,\" Science, vol. 259, pp. 1614-1616, 1993. </td>
	</tr>
	<tr>
		<td>[Jelkmann2011]</td>
		<td>W. Jelkmann, \"Regulation of erythropoietin production,\" The Journal of Physiology, vol. 589, pp. 1251-1258, March 15, 2011 2011. </td>
	</tr>
	<tr>
		<td>[Jelkmann1987]</td>
		<td>W. Jelkmann and J. Seidl, \"Dependence of erythropoietin production on blood oxygen affinity and hemoglobin concentration in rats,\" Biomedica biochimica acta, vol. 46, pp. S304-8, 1987 1987. </td>
	</tr>
	<tr>
		<td>[JÉQuier2002]</td>
		<td>E. JÉQuier, \"Leptin Signaling, Adiposity, and Energy Balance,\" Annals of the New York Academy of Sciences, vol. 967, pp. 379-388, 2002. </td>
	</tr>
	<tr>
		<td>[Johns1989]</td>
		<td>E. J. Johns, \"Role of angiotensin II and the sympathetic nervous system in the control of renal function,\" Journal of Hypertension, vol. 7, pp. 695-702, 1989. </td>
	</tr>
	<tr>
		<td>[Jordan1998]</td>
		<td>J. Jordan, J. R. Shannon, B. K. Black, R. H. Lance, M. D. Squillante, F. Costa, et al., \"NN-Nicotinic Blockade as an Acute Human Model of Autonomic Failure,\" Hypertension, vol. 31, pp. 1178-1184, May 1, 1998 1998. </td>
	</tr>
	<tr>
		<td>[Joseph1952]</td>
		<td>J. Joseph and A. Nightingale, \"Electromyography of muscles of posture: leg muscles in males,\" The Journal of Physiology, vol. 117, pp. 484-491, August 28, 1952 1952. </td>
	</tr>
	<tr>
		<td>[Jungblut2008]</td>
		<td>P. R. Jungblut, H. G. Holzhütter, R. Apweiler, and H. Schlüter, \"The speciation of the proteome,\" Chemistry Central Journal, vol. 2, pp. 1-10, 2008. </td>
	</tr>
	<tr>
		<td>[Källskog1975]</td>
		<td>Ö. Källskog and M. Wolgast, \"Effect of elevated interstitial pressure on the renal cortical hemodynamics,\" Acta Physiologica Scandinavica, vol. 95, pp. 364-372, 1975. </td>
	</tr>
	<tr>
		<td>[Kamel1990]</td>
		<td>K. S. Kamel, J. H. Ethier, B. J. Stinebaugh, F. X. Schloeder, and M. L. Halperin, \"Removal of an inorganic acid load in subjects with ketoacidosis of chronic fasting,\" Kidney Int, vol. 38, pp. 507-511, 09//print 1990. </td>
	</tr>
	<tr>
		<td>[Kamel1998]</td>
		<td>K. S. Kamel, S.-H. Lin, S. Cheema-Dhadli, E. B. Marliss, and M. L. Halperin, \"Prolonged total fasting: A feast for the integrative physiologist,\" Kidney Int, vol. 53, pp. 531-539, 03//print 1998. </td>
	</tr>
	<tr>
		<td>[Kamon1968]</td>
		<td>E. Kamon and H. S. Belding, Heat uptake and dermal conductance in forearm and hand when heated vol. 24, 1968. </td>
	</tr>
	<tr>
		<td>[Kappagoda1976]</td>
		<td>C. Kappagoda and R. Linden, \"The use of SI units in cardiovascular studies,\" British heart journal, vol. 38, p. 219, 1976. </td>
	</tr>
	<tr>
		<td>[Katkov1980]</td>
		<td>V. E. Katkov and V. V. Chestukhin, \"Blood pressure and oxygenation in different cardiovascular compartments of a normal man during postural exposures,\" Aviat Space Environ Med, vol. 51, pp. 1234-42, Nov 1980. </td>
	</tr>
	<tr>
		<td>[Katschinski2004]</td>
		<td>D. M. Katschinski, \"On heat and cells and proteins,\" Physiology, vol. 19, pp. 11-15, 2004. </td>
	</tr>
	<tr>
		<td>[Katsura1992]</td>
		<td>K. Katsura, B. Asplund, A. Ekholm, and B. K. Siesjo, \"Extra- and Intracellular pH in the Brain During Ischaemia, Related to Tissue Lactate Content in Normo- and Hypercapnic rats,\" Eur J Neurosci, vol. 4, pp. 166-176, 1992. </td>
	</tr>
	<tr>
		<td>[Kelly1992]</td>
		<td>R. A. Kelly and T. W. Smith, \"Use and misuse of digitalis blood levels,\" Heart disease and stroke : a journal for primary care physicians, vol. 1, pp. 117-122, 1992 May-Jun 1992. </td>
	</tr>
	<tr>
		<td>[Kelso1982]</td>
		<td>S. Kelso and J. Boulant, \"Effect of synaptic blockade on thermosensitive neurons in hypothalamic tissue slices,\" Am J Physiol, vol. 243, pp. R480-R490, 1982. </td>
	</tr>
	<tr>
		<td>[Kervran1990]</td>
		<td>A. Kervran, M. Dubrasquet, P. Blache, J. Martinez, and D. Bataille, \"Metabolic clearance rates of oxyntomodulin and glucagon in the rat: contribution of the kidney,\" Regulatory Peptides, vol. 31, pp. 41-52, 10/29/ 1990. </td>
	</tr>
	<tr>
		<td>[Kety1948]</td>
		<td>S. S. Kety and C. F. Schmidt, \"THE EFFECTS OF ALTERED ARTERIAL TENSIONS OF CARBON DIOXIDE AND OXYGEN ON CEREBRAL BLOOD FLOW AND CEREBRAL OXYGEN CONSUMPTION OF NORMAL YOUNG MEN 1,\" The Journal of Clinical Investigation, vol. 27, pp. 484-492, 1948. </td>
	</tr>
	<tr>
		<td>[Khokhar1976]</td>
		<td>A. Khokhar, J. Slater, M. L. Forsling, and N. Payne, \"Effect of vasopressin on plasma volume and renin release in man,\" Clinical Science, vol. 50, pp. 415-424, 1976. </td>
	</tr>
	<tr>
		<td>[Kiil1990]</td>
		<td>F. Kiil, \"The paradox of renal bicarbonate reabsorption,\" Physiology, vol. 5, pp. 13-17, 1990. </td>
	</tr>
	<tr>
		<td>[Kim0000]</td>
		<td>H. H. Kim, S. Lee, T. Y. Jeon, H. C. Son, Y. J. Kim, and M. S. Sim, \"Post-prandial plasma ghrelin levels in people with different breakfast hours,\" Eur J Clin Nutr, vol. 58, pp. 692-695, //print 0000. </td>
	</tr>
	<tr>
		<td>[Kimura1983]</td>
		<td>S. Kimura, Y. Miura, M. Adachi, M. Adachi, M. Nezu, S. Toriyabe, et al., \"The effect of sodium depletion on plasma norepinephrine kinetics in patients with essential hypertension,\" Japanese circulation journal, vol. 47, pp. 1232-1241, 1983/10// 1983. </td>
	</tr>
	<tr>
		<td>[Kintner2000]</td>
		<td>D. B. Kintner, M. K. Anderson, J. H. Fitzpatrick, Jr., K. A. Sailor, and D. D. Gilboe, \"31P-MRS-based determination of brain intracellular and interstitial pH: its application to in vivo H+ compartmentation and cellular regulation during hypoxic/ischemic conditions,\" Neurochem Res, vol. 25, pp. 1385-96, Oct 2000. </td>
	</tr>
	<tr>
		<td>[Kintner2000]</td>
		<td>D. B. Kintner, M. K. Anderson, J. H. Fitzpatrick, Jr., K. A. Sailor, and D. D. Gilboe, \"31P-MRS-based determination of brain intracellular and interstitial pH: its application to in vivo H+ compartmentation and cellular regulation during hypoxic/ischemic conditions,\" Neurochem Res, vol. 25, pp. 1385-96, Oct 2000. </td>
	</tr>
	<tr>
		<td>[Kintner1999]</td>
		<td>D. B. Kintner, M. E. Anderson, K. A. Sailor, G. Dienel, J. H. Fitzpatrick, Jr., and D. D. Gilboe, \"In vivo microdialysis of 2-deoxyglucose 6-phosphate into brain: a novel method for the measurement of interstitial pH using 31P-NMR,\" J Neurochem, vol. 72, pp. 405-12, Jan 1999. </td>
	</tr>
	<tr>
		<td>[Kirsch1993]</td>
		<td>K. A. Kirsch, F. J. Baartz, H. C. Gunga, L. Röcker, H. J. Wicke, and B. Bünsch, \"Fluid shifts into and out of superficial tissues under microgravity and terrestrial conditions,\" The clinical investigator, vol. 71, pp. 687-689, 1993/09/01 1993. </td>
	</tr>
	<tr>
		<td>[Kirsch1993]</td>
		<td>K. A. Kirsch, F. J. Baartz, H. C. Gunga, L. Röcker, H. J. Wicke, and B. Bünsch, \"Fluid shifts into and out of superficial tissues under microgravity and terrestrial conditions,\" The clinical investigator, vol. 71, pp. 687-689, 1993/09/01 1993. </td>
	</tr>
	<tr>
		<td>[Kjeldsen1983]</td>
		<td>S. E. Kjeldsen, I. Eide, I. Aakesson, and P. Leren, \"Increased arterial catecholamine concentrations in 50-year-old men with essential hypertension,\" Scandinavian Journal of Clinical & Laboratory Investigation, vol. 43, pp. 343-349, 1983. </td>
	</tr>
	<tr>
		<td>[Knepper1977]</td>
		<td>M. A. Knepper, R. A. Danielson, G. M. Saidel, and R. S. Post, \"Quantitative analysis of renal medullary anatomy in rats and rabbits,\" Kidney Int, vol. 12, pp. 313-323, 1977. </td>
	</tr>
	<tr>
		<td>[Knepper2003]</td>
		<td>M. A. Knepper, G. M. Saidel, V. C. Hascall, and T. Dwyer, Concentration of solutes in the renal inner medulla: interstitial hyaluronan as a mechano-osmotic transducer vol. 284, 2003. </td>
	</tr>
	<tr>
		<td>[Koeffler1981]</td>
		<td>H. P. Koeffler and E. Goldwasser, \"Erythropoietin Radioimmunoassay in Evaluating Patients with Polycythemia,\" Annals of Internal Medicine, vol. 94, pp. 44-47, 1981. </td>
	</tr>
	<tr>
		<td>[Kofranek2007]</td>
		<td>J. Kofranek, S. Matousek, and M. Andrlik, \"Border flux balance approach towards modelling acid-base chemistry and blood gases transport,\" in In: Proceedings of the 6th EUROSIM congress on modelling and simulation. Ljubljana: University of Ljubljana, 2007, pp. 1-9. </td>
	</tr>
	<tr>
		<td>[Kofranek2011]</td>
		<td>J. Kofranek, S. Matousek, J. Rusz, P. Stodulka, P. Privitzer, M. Matejak, et al., \"The Atlas of Physiology and Pathophysiology: Web-based multimedia enabled interactive simulations,\" Computer methods and programs in biomedicine, vol. 104, pp. 143-153, 2011. </td>
	</tr>
	<tr>
		<td>[Kofránek2002]</td>
		<td>J. Kofránek, Andrlík, Michal, Kripner, Tomáš, and Mašek, Jan, \"From art to industry in design of biomedical simulators. Experience of the Golem simulator project.,\" presented at the The 6th World Multiconference on Systemics, Cybernetics and Informatics., Orlando, Florida, USA, 2002. </td>
	</tr>
	<tr>
		<td>[Kofránek2013]</td>
		<td>J. Kofránek, Mateják, M., Privitzer, P., Tribula, M., Kulhánek, T., Šilar, J., Pecinovský, R., \"HumMod-Golem Edition: large scale model of integrative physiology for virtual patient simulators,\" in World Congress in Computer Science 2013 (WORLDCOMP'13), International Conference on Modeling, Simulation and Visualisation Methods (MSV'13), 2013, pp. 182-188. </td>
	</tr>
	<tr>
		<td>[Kofránek2008]</td>
		<td>J. Kofránek, J. Rusz, and S. Matoušek, \"Vzkříšení Guytonova diagramu-Od obrázku k simulačnímu modelu,\" MEDSOFT 2008, vol. 2008, pp. 37-56, 2008. </td>
	</tr>
	<tr>
		<td>[Kofránek2009]</td>
		<td>J. Kofránek, M. Mateják, and P. Privitzer, \"Leaving toil to machines - building simulation kernel of educational software in modern software environments,\" in Mefanet 2009, Masaryk University, Brno, 2009. </td>
	</tr>
	<tr>
		<td>[Kofránek2010]</td>
		<td>J. Kofránek, M. Mateják, and P. Privitzer, \"Web simulator creation technology,\" MEFANET report, vol. 3, pp. 52-97, 2010. </td>
	</tr>
	<tr>
		<td>[Jiří2011]</td>
		<td>J. Kofránek, M. Mateják, and P. Privitzer, \"HumMod - large scale physiological model in Modelica,\" in 8th. International Modelica Conference, Dresden, Germany, 2011. </td>
	</tr>
	<tr>
		<td>[Kofránek2008]</td>
		<td>J. Kofránek, M. Mateják, P. Privitzer, and M. Tribula, \"Causal or acausal modeling: labour for humans or labour for machines,\" Technical Conmputing Prague, pp. 1-16, 2008. </td>
	</tr>
	<tr>
		<td>[Kokot1994]</td>
		<td>M. Kokot, F. Kokot, E. Franek, A. Wiecek, M. Nowicki, and J. Duława, \"Effect of isobaric hyperoxemia on erythropoietin secretion in hypertensive patients,\" Hypertension, vol. 24, pp. 486-90, October 1, 1994 1994. </td>
	</tr>
	<tr>
		<td>[Kotani2004]</td>
		<td>K. Kotani, O. D. Peroni, Y. Minokoshi, O. Boss, and B. B. Kahn, \"GLUT4 glucose transporter deficiency increases hepatic lipid production and peripheral lipid utilization,\" The Journal of clinical investigation, vol. 114, pp. 1666-1675, 2004. </td>
	</tr>
	<tr>
		<td>[Kraig1985]</td>
		<td>R. P. Kraig, W. A. Pulsinelli, and F. Plum, \"Heterogeneous Distribution of Hydrogen and Bicarbonate Ions During Complete Brain Cischemia,\" in Progress in Brain Research. vol. Volume 63, K. A. H. B. K. S. K. Kogure and F. A. Welsh, Eds., ed: Elsevier, 1985, pp. 155-166. </td>
	</tr>
	<tr>
		<td>[Krasney1977]</td>
		<td>J. A. Krasney and R. C. Koehler, Influence of arterial hypoxia on cardiac and coronary dynamics in the conscious sinoaortic-denervated dog vol. 43, 1977. </td>
	</tr>
	<tr>
		<td>[Krekels1997]</td>
		<td>M. M. Krekels, N. C. Schaper, and P. W. de Leeuw, \"Sensitivity of blood pressure and renin activation during sodium restriction,\" Hypertension, vol. 30, pp. 1216-1222, 1997. </td>
	</tr>
	<tr>
		<td>[Krogh1932]</td>
		<td>A. Krogh, E. Landis, and A. Turner, \"The movement of fluid through the human capillary wall in relation to venous pressure and to the colloid osmotic pressure of the blood,\" Journal of Clinical Investigation, vol. 11, p. 63, 1932. </td>
	</tr>
	<tr>
		<td>[Tomáš2014]</td>
		<td>T. Kulhánek, M. Mateják, J. Šilar, and J. Kofránek, \"Identifikace fyziologických systémů,\" Medsoft, pp. 148-153, 2014. </td>
	</tr>
	<tr>
		<td>[Kulhánek]</td>
		<td>T. Kulhánek, J. Šilar, J. Kofránek, M. Mateják, P. Privitzer, and M. Tribula, \"Od výukového modelu k identifikaci fyziologického systému (cze) From educational models towards identification of physiological system (ENG).\"</td>
	</tr>
	<tr>
		<td>[Kulhánek2010]</td>
		<td>T. Kulhánek, J. Šilar, M. Mateják, P. Privitzer, J. Kofránek, and M. Tribula, \"Distributed computation and parameter estimation in identification of physiological systems,\" in VPH conference, 2010. </td>
	</tr>
	<tr>
		<td>[Kulhánek2013]</td>
		<td>T. Kulhánek, M. Mateják, P. P. JanŠilar, M. Tribula, F. Jezek, and J. Kofránek, \"Hybrid architecture for web simulators of pathological physiology,\" 2013. </td>
	</tr>
	<tr>
		<td>[Kulhanek2]</td>
		<td>KulhánekT. Kulhánek, F. Jezek, M. Mateják, J. Šilar, P. Privitzer, M. Tribula, et al., \"RESTful web service to build loosely coupled web based simulation of human physiology.\"</td>
	</tr>
	<tr>
		<td>[Kumagai1994]</td>
		<td>K. Kumagai and I. A. Reid, \"Angiotensin II exerts differential actions on renal nerve activity and heart rate,\" Hypertension, vol. 24, pp. 451-456, 1994. </td>
	</tr>
	<tr>
		<td>[Kunert1996]</td>
		<td>M. P. Kunert, J. F. Liard, D. J. Abraham, and J. H. Lombard, \"Low-Affinity Hemoglobin Increases Tissue PO2and Decreases Arteriolar Diameter and Flow in the Rat Cremaster Muscle,\" Microvascular Research, vol. 52, pp. 58-68, 7// 1996. </td>
	</tr>
	<tr>
		<td>[Kurtz1983]</td>
		<td>I. Kurtz, T. Maher, H. N. Hulter, M. Schambelan, and A. Sebastian, \"Effect of diet on plasma acid-base composition in normal humans,\" Kidney Int, vol. 24, pp. 670-80, Nov 1983. </td>
	</tr>
	<tr>
		<td>[Kuwahira1993]</td>
		<td>I. Kuwahira, N. Heisler, J. Piiper, and N. C. Gonzalez, \"Effect of chronic hypoxia on hemodynamics, organ blood flow and O2 supply in rats,\" Respiration Physiology, vol. 92, pp. 227-238, 5// 1993. </td>
	</tr>
	<tr>
		<td>[Lahiri1975]</td>
		<td>S. Lahiri and R. G. DeLaney, \"Stimulus inte" + "raction in the responses of carotid body chemoreceptor single afferent fibers,\" Respir Physiol, vol. 24, pp. 249-66, Sep 1975. </td>
	</tr>
	<tr>
		<td>[Lahiri1981]</td>
		<td>S. Lahiri, A. Mokashi, E. Mulligan, and T. Nishino, Comparison of aortic and carotid chemoreceptor responses to hypercapnia and hypoxia vol. 51, 1981. </td>
	</tr>
	<tr>
		<td>[Laine1979]</td>
		<td>G. A. Laine, J. T. Hall, S. H. Laine, and J. Granger, \"Transsinusoidal fluid dynamics in canine liver during venous hypertension,\" Circulation Research, vol. 45, pp. 317-23, September 1, 1979 1979. </td>
	</tr>
	<tr>
		<td>[Laine1987]</td>
		<td>G. A. Laine, S. J. Allen, J. Katz, J. C. Gabel, and R. E. Drake, \"Outflow pressure reduces lymph flow rate from various tissues,\" Microvascular Research, vol. 33, pp. 135-142, 1// 1987. </td>
	</tr>
	<tr>
		<td>[Lake1979]</td>
		<td>C. R. Lake, \"Relationship of Sympathetic Nervous System Tone and Blood Pressure,\" Nephron, vol. 23, pp. 84-90, 1979. </td>
	</tr>
	<tr>
		<td>[Lake1976]</td>
		<td>C. R. Lake, M. G. Ziegler, and I. J. Kopin, \"Use of plasma norepinephrine for evaluation of sympathetic neuronal function in man,\" Life sciences, vol. 18, pp. 1315-1325, 1976. </td>
	</tr>
	<tr>
		<td>[LaManna1996]</td>
		<td>J. LaManna, \"Hypoxia/Ischemia and the pH Paradox,\" in Oxygen Transport to Tissue XVII. vol. 388, C. Ince, J. Kesecioglu, L. Telci, and K. Akpir, Eds., ed: Springer US, 1996, pp. 283-292. </td>
	</tr>
	<tr>
		<td>[Lambertsen1960]</td>
		<td>C. J. Lambertsen, \"CARBON DIOXIDE AND RESPIRATION IN ACID-BASE HOMEOSTASIS,\" Anesthesiology, vol. 21, pp. 642-651, 1960. </td>
	</tr>
	<tr>
		<td>[Lambertsen1953]</td>
		<td>C. J. Lambertsen, R. H. Kough, D. Y. Cooper, G. L. Emmel, H. H. Loeschcke, and C. F. Schmidt, Comparison of Relationship of Respiratory Minute Volume to pCO2 and pH of Arterial and Internal Jugular Blood in Normal Man During Hyperventilation Produced by Low Concentrations of CO2 at 1 Atmosphere and by O2 at 3.0 Atmospheres vol. 5, 1953. </td>
	</tr>
	<tr>
		<td>[Lambertsen1959]</td>
		<td>C. J. Lambertsen, S. G. Owen, H. Wendel, M. W. Stroud, A. A. Lurie, W. Lochner, et al., Respiratory and cerebral circulatory control during exercise at .21 and 2.0 atmospheres inspired pO2 vol. 14, 1959. </td>
	</tr>
	<tr>
		<td>[Landis1933]</td>
		<td>E. M. Landis and J. H. Gibbon Jr, \"The effects of temperature and of tissue pressure on the movement of fluid through the human capillary wall,\" Journal of Clinical Investigation, vol. 12, p. 105, 1933. </td>
	</tr>
	<tr>
		<td>[Landis1933]</td>
		<td>E. M. Landis and J. H. Gibbon, Jr., \"THE EFFECTS OF TEMPERATURE AND OF TISSUE PRESSURE ON THE MOVEMENT OF FLUID THROUGH THE HUMAN CAPILLARY WALL,\" The Journal of Clinical Investigation, vol. 12, pp. 105-138, 1933. </td>
	</tr>
	<tr>
		<td>[Langer1997]</td>
		<td>G. A. Langer, The myocardium: Academic Press, 1997. </td>
	</tr>
	<tr>
		<td>[Lankford1991]</td>
		<td>S. P. Lankford, C. Chou, Y. Terada, S. M. Wall, J. B. Wade, and M. A. Knepper, \"Regulation of collecting duct water permeability independent of cAMP-mediated AVP response,\" American Journal of Physiology-Renal Physiology, vol. 261, pp. F554-F566, 1991. </td>
	</tr>
	<tr>
		<td>[Larsdotter2003]</td>
		<td>E. Larsdotter Nilsson and P. Fritzson, \"BioChem-A Biological and Chemical Library for Modelica,\" in Proceedings of the 3rd International Modelica Conference (November 3-4, Linköping, Sweden), 2003. </td>
	</tr>
	<tr>
		<td>[Larsen1972]</td>
		<td>P. R. Larsen, \"Direct immunoassay of triiodothyronine in human serum,\" The Journal of Clinical Investigation, vol. 51, pp. 1939-1949, 1972. </td>
	</tr>
	<tr>
		<td>[Lash1987]</td>
		<td>J. M. Lash and H. G. Bohlen, Perivascular and tissue PO2 in contracting rat spinotrapezius muscle vol. 252, 1987. </td>
	</tr>
	<tr>
		<td>[Lassen1959]</td>
		<td>N. A. Lassen, Cerebral blood flow and oxygen consumption in man: Am Physiological Soc, 1959. </td>
	</tr>
	<tr>
		<td>[Lassen1990]</td>
		<td>N. A. Lassen, \"Is central chemoreceptor sensitive to intracellular rather than extracellular pH?,\" Clinical Physiology, vol. 10, pp. 311-319, 1990. </td>
	</tr>
	<tr>
		<td>[Latzka1999]</td>
		<td>W. A. Latzka and S. J. Montain, \"Water and electrolyte requirements for exercise,\" Clinics in sports medicine, vol. 18, pp. 513-524, 1999. </td>
	</tr>
	<tr>
		<td>[LAUGHLIN1987]</td>
		<td>M. H. LAUGHLIN, \"Skeletal muscle blood flow capacity: role of muscle pump in exercise hyperemia,\" Am J Physiol, vol. 253, p. 1004, 1987. </td>
	</tr>
	<tr>
		<td>[Laughlin1983]</td>
		<td>M. H. Laughlin and R. Armstrong, \"Rat muscle blood flows as a function of time during prolonged slow treadmill exercise,\" Am J Physiol Heart Circ Physiol, vol. 244, pp. H814-H824, 1983. </td>
	</tr>
	<tr>
		<td>[Lautt1987]</td>
		<td>W. W. Lautt, C. V. Greenway, and D. J. Legare, \"Effect of hepatic nerves, norepinephrine, angiotensin, and elevated central venous pressure on postsinusoidal resistance sites and intrahepatic pressures in cats,\" Microvascular Research, vol. 33, pp. 50-61, 1// 1987. </td>
	</tr>
	<tr>
		<td>[Layton2004]</td>
		<td>A. T. Layton, T. L. Pannabecker, W. H. Dantzler, and H. E. Layton, Two modes for concentrating urine in rat inner medulla vol. 287, 2004. </td>
	</tr>
	<tr>
		<td>[Legendre1991]</td>
		<td>B. B. Legendre, S. Estrade, R. Cassingena, P. Ronco, and A. Vandewalle, \"Why Don’t Our Feet Swell in the Upright Position?,\" J. Cell Biol, vol. 113, pp. 951-962, 1991. </td>
	</tr>
	<tr>
		<td>[Leichtweiss1969]</td>
		<td>H. P. Leichtweiss, D. W. Lübbers, C. Weiss, H. Baumgärtl, and W. Reschke, \"The oxygen supply of the rat kidney: Measurements of intrarenalpO2,\" Pflügers Archiv, vol. 309, pp. 328-349, 1969/12/01 1969. </td>
	</tr>
	<tr>
		<td>[Lemieux1971]</td>
		<td>G. Lemieux, P. Vinay, P. Robitaille, G. Plante, xE, E. rard, et al., \"The effect of ketone bodies on renal ammoniogenesis,\" The Journal of Clinical Investigation, vol. 50, pp. 1781-1791, 1971. </td>
	</tr>
	<tr>
		<td>[Lennon1966]</td>
		<td>E. Lennon, J. Lemann Jr, and J. Litzow, \"The effects of diet and stool composition on the net external acid balance of normal subjects,\" Journal of Clinical Investigation, vol. 45, p. 1601, 1966. </td>
	</tr>
	<tr>
		<td>[Lennon1966]</td>
		<td>E. Lennon, J. Lemann Jr, and J. Litzow, \"The effects of diet and stool composition on the net external acid balance of normal subjects,\" Journal of Clinical Investigation, vol. 45, p. 1601, 1966. </td>
	</tr>
	<tr>
		<td>[Levick1991]</td>
		<td>Levick, \"Capillary filtration-absorption balance reconsidered in light of dynamic extravascular factors,\" Experimental Physiology, vol. 76, pp. 825-857, November 1, 1991 1991. </td>
	</tr>
	<tr>
		<td>[Levy1959]</td>
		<td>M. N. Levy and G. Sauceda, Diffusion of oxygen from arterial to venous segments of renal capillaries vol. 196, 1959. </td>
	</tr>
	<tr>
		<td>[Liljenquist1974]</td>
		<td>J. E. Liljenquist, J. D. Bomboy, S. B. Lewis, B. C. Sinclair-Smith, P. W. Felts, W. W. Lacy, et al., \"Effects of Glucagon on Lipolysis and Ketogenesis in Normal and Diabetic Men,\" The Journal of Clinical Investigation, vol. 53, pp. 190-197, 1974. </td>
	</tr>
	<tr>
		<td>[Liljenquist1977]</td>
		<td>J. Liljenquist, G. Mueller, A. Cherrington, U. Keller, C. JL, J. Perry, et al., \"Evidence for an important role of glucagon in the regulation of hepatic glucose production in normal man,\" Journal of Clinical Investigation, vol. 59, p. 369, 1977. </td>
	</tr>
	<tr>
		<td>[Lillioja1985]</td>
		<td>S. Lillioja, C. Bogardus, D. M. Mott, A. L. Kennedy, W. C. Knowler, and B. V. Howard, \"Relationship between insulin-mediated glucose disposal and lipid metabolism in man,\" Journal of Clinical Investigation, vol. 75, p. 1106, 1985. </td>
	</tr>
	<tr>
		<td>[Lipkin1954]</td>
		<td>M. Lipkin and J. D. Hardy, Measurement of Some Thermal Properties of Human Tissues vol. 7, 1954. </td>
	</tr>
	<tr>
		<td>[Little1993]</td>
		<td>W. C. Little and C. P. Cheng, \"Effect of exercise on left ventricular-arterial coupling assessed in the pressure-volume plane,\" AMERICAN JOURNAL OF PHYSIOLOGY, vol. 264, pp. H1629-H1629, 1993. </td>
	</tr>
	<tr>
		<td>[Little1975]</td>
		<td>R. Little, G. Wennergren, and B. ÖBerg, \"Aspects of the central integration of arterial baroreceptor and cardiac ventricular receptor reflexes in the cat,\" Acta Physiologica Scandinavica, vol. 93, pp. 85-96, 1975. </td>
	</tr>
	<tr>
		<td>[Livett1981]</td>
		<td>B. G. Livett, D. M. Dean, L. G. Whelan, S. Udenfriend, and J. Rossier, \"Co-release of enkephalin and catecholamines from cultured adrenal chromaffin cells,\" Nature, vol. 289, pp. 317-319, 01/22/print 1981. </td>
	</tr>
	<tr>
		<td>[Lohmeier1998]</td>
		<td>T. E. Lohmeier and D. A. Hildebrandt, \"Renal Nerves Promote Sodium Excretion in Angiotensin-Induced Hypertension,\" Hypertension, vol. 31, pp. 429-434, January 1, 1998 1998. </td>
	</tr>
	<tr>
		<td>[Lopez-Barneo1993]</td>
		<td>J. Lopez-Barneo, A. Benot, and J. Urena, Oxygen Sensing and the Electrophysiology of Arterial Chemoreceptor Cells vol. 8, 1993. </td>
	</tr>
	<tr>
		<td>[Lugliani1973]</td>
		<td>R. Lugliani, B. J. Whipp, and K. Wasserman, \"A role for the carotid body in cardiovascular control in man,\" Chest, vol. 63, pp. 744-750, 1973. </td>
	</tr>
	<tr>
		<td>[Lugliani1971]</td>
		<td>R. Lugliani, B. J. Whipp, C. Seard, and K. Wasserman, \"Effect of Bilateral Carotid-Body Resection on Ventilatory Control at Rest and during Exercise in Man,\" New England Journal of Medicine, vol. 285, pp. 1105-1111, 1971. </td>
	</tr>
	<tr>
		<td>[Maack1985]</td>
		<td>T. Maack, M. J. F. Camargo, H. D. Kleinert, J. H. Laragh, and S. A. Atlas, \"Atrial natriuretic factor: structure and functional properties,\" Kidney Int, vol. 27, pp. 607-615, 1985. </td>
	</tr>
	<tr>
		<td>[Maass-Moreno1992]</td>
		<td>R. Maass-Moreno and C. F. Rothe, \"Contribution of the large hepatic veins to postsinusoidal vascular resistance,\" Am J Physiol Gastrointest Liver Physiol, vol. 262, pp. G14-G22, 1992. </td>
	</tr>
	<tr>
		<td>[MacGregor1981]</td>
		<td>G. MacGregor, N. Markandu, J. Roulston, J. Jones, and J. Morton, \"Maintenance of blood pressure by the renin–angiotensin system in normal man,\" 1981. </td>
	</tr>
	<tr>
		<td>[Maddox1974]</td>
		<td>D. A. Maddox, W. M. Deen, and B. M. Brenner, \"Dynamics of glomerular ultrafiltration. VI. Studies in the primate,\" Kidney international, vol. 5, pp. 271-278, 1974/04// 1974. </td>
	</tr>
	<tr>
		<td>[Madison1958]</td>
		<td>L. L. Madison and D. W. Seldin, \"Ammonia Excretion and Renal Enzymatic Adaptation in Human Subjects, as Disclosed by Administration of Precursor Amino Acids12,\" The Journal of Clinical Investigation, vol. 37, pp. 1615-1627, 1958. </td>
	</tr>
	<tr>
		<td>[Majid1997]</td>
		<td>D. S. A. Majid, M. Godfrey, and S. A. Omoro, \"Pressure Natriuresis and Autoregulation of Inner Medullary Blood Flow in Canine Kidney,\" Hypertension, vol. 29, pp. 210-215, January 1, 1997 1997. </td>
	</tr>
	<tr>
		<td>[Malberti1999]</td>
		<td>F. Malberti, M. Farina, and E. Imbasciati, \"The PTH-calcium curve and the set point of calcium in primary and secondary hyperparathyroidism,\" Nephrology Dialysis Transplantation, vol. 14, pp. 2398-2406, 1999. </td>
	</tr>
	<tr>
		<td>[Malberti1999]</td>
		<td>F. Malberti, M. Farina, and E. Imbasciati, \"The PTH-calcium curve and the set point of calcium in primary and secondary hyperparathyroidism,\" Nephrology Dialysis Transplantation, vol. 14, pp. 2398-2406, 1999. </td>
	</tr>
	<tr>
		<td>[Malnic1989]</td>
		<td>G. Malnic, R. W. Berliner, and G. Giebisch, Flow dependence of K+ secretion in cortical distal tubules of the rat vol. 256, 1989. </td>
	</tr>
	<tr>
		<td>[Malo1984]</td>
		<td>J. Malo, H. Goldberg, R. Graham, H. Unruh, and C. Skoog, Effect of hypoxic hypoxia on systemic vasculature vol. 56, 1984. </td>
	</tr>
	<tr>
		<td>[Manning1987]</td>
		<td>R. D. Manning, Renal hemodynamic, fluid volume, and arterial pressure changes during hyperproteinemia vol. 252, 1987. </td>
	</tr>
	<tr>
		<td>[Manning1990]</td>
		<td>R. D. Manning, Effects of hypoproteinemia on blood volume and arterial pressure of volume-loaded dogs vol. 259, 1990. </td>
	</tr>
	<tr>
		<td>[Manning1980]</td>
		<td>R. D. Manning and A. C. Guyton, Dynamics of fluid distribution between the blood and interstitium during overhydration vol. 238, 1980. </td>
	</tr>
	<tr>
		<td>[Manning1983]</td>
		<td>R. D. Manning and A. C. Guyton, Effects of hypoproteinemia on fluid volumes and arterial pressure vol. 245, 1983. </td>
	</tr>
	<tr>
		<td>[Mantzoros2011]</td>
		<td>C. S. Mantzoros, F. Magkos, M. Brinkoetter, E. Sienkiewicz, T. A. Dardeno, S.-Y. Kim, et al., Leptin in human physiology and pathophysiology vol. 301, 2011. </td>
	</tr>
	<tr>
		<td>[Marcus1992]</td>
		<td>F. Marcus, \"Use and toxicity of digitalis,\" Heart disease and stroke: a journal for primary care physicians, vol. 1, p. 27, 1992. </td>
	</tr>
	<tr>
		<td>[Marshall1995]</td>
		<td>J. Marshall, Skeletal Muscle Vasculature and Systemic Hypoxia vol. 10, 1995. </td>
	</tr>
	<tr>
		<td>[Marshall1988]</td>
		<td>J. M. Marshall and J. D. Metcalfe, \"Analysis of the cardiovascular changes induced in the rat by graded levels of systemic hypoxia,\" The Journal of Physiology, vol. 407, pp. 385-403, December 1, 1988 1988. </td>
	</tr>
	<tr>
		<td>[Maruyama1984]</td>
		<td>H. Maruyama, A. Hisatomi, L. Orci, G. M. Grodsky, and R. H. Unger, \"Insulin within islets is a physiologic glucagon release inhibitor,\" The Journal of Clinical Investigation, vol. 74, pp. 2296-2299, 1984. </td>
	</tr>
	<tr>
		<td>[Mason1964]</td>
		<td>D. T. Mason, E. Braunwald, R. B. Karsh, and F. A. Bullock, \"Studies on Digitalis. X. Effects of Ouabain on Forearm Vascular Resistance and Venous Tone in Normal Subjects and in Patients in Heart Failure *,\" The Journal of Clinical Investigation, vol. 43, pp. 532-543, 1964. </td>
	</tr>
	<tr>
		<td>[Massara1980]</td>
		<td>F. Massara, S. Martelli, E. Cagliero, F. Camanni, and G. Molinatti, \"Influence of glucagon on plasma levels of potassium in man,\" Diabetologia, vol. 19, pp. 414-417, 1980. </td>
	</tr>
        <tr>
	        <td>[Marek2015]</td>
		<td>M. Mateják, T. Kulhánek, and S. Matoušek, \"Adair-based hemoglobin equilibrium with oxygen, carbon dioxide and hydrogen ion activity,\" Scandinavian Journal of Clinical & Laboratory Investigation, pp. 1-8, 2015.</td>
	</tr>
	<tr>
		<td>[Marek2014]</td>
		<td>M. Mateják, \"Physiolibrary - fyziológia v Modelice,\" Medsoft, 2014. </td>
	</tr>
	<tr>
		<td>[Marek2010]</td>
		<td>M. Mateják and J. Kofránek, \"Rozsáhlý model fyziologických regulací v Modelice,\" Medsoft, pp. 126-146, 2010. </td>
	</tr>
	<tr>
		<td>[Marek2011]</td>
		<td>M. Mateják and J. Kofránek, \"HumMod–Golem Edition–Rozsáhlý model fyziologických systémů,\" Medsoft, pp. 182-196, 2011. </td>
	</tr>
	<tr>
		<td>[Mateják2009]</td>
		<td>M. Mateják, J. Kofránek, and J. Rusz, \"Akauzální\" vzkříšení\" Guytonova diagramu,\" Medsoft 2009, p. 105, 2009. </td>
	</tr>
	<tr>
		<td>[Mateják2012]</td>
		<td>M. Mateják, B. Nedvědová, A. Doležalová, J. Kofránek, and T. Kulhánek, \"Model ECMO oxygenátoru,\" Medsoft, pp. 205-2014, 2012. </td>
	</tr>
	<tr>
		<td>[Marek2014]</td>
		<td>M. Mateják, T. Kulhánek, J. Šilar, P. Privitzer, F. Ježek, and J. Kofránek, \"Physiolibrary - Modelica library for Physiology,\" in 10th International Modelica Conference, Lund, Sweden, 2014. </td>
	</tr>
	<tr>
		<td>[Mathias2013]</td>
		<td>C. J. Mathias and R. Bannister, Autonomic failure: a textbook of clinical disorders of the autonomic nervous system: OUP Oxford, 2013. </td>
	</tr>
	<tr>
		<td>[MATSUOKA1994]</td>
		<td>T. MATSUOKA, A. DOTTA, and J. P. MORTOLA, \"Metabolic response to ambient temperature and hypoxia in sinoaortic-denervated rats,\" METHODS, vol. 14, p. 19, 1994. </td>
	</tr>
	<tr>
		<td>[Mattson1997]</td>
		<td>S. E. Mattson, H. Elmqvist, and J. F. Broenink, \"Modelica: An international effort to design the next generation modelling language,\" Journal A, vol. 38, pp. 16-19, 1997. </td>
	</tr>
	<tr>
		<td>[Mattsson1998]</td>
		<td>S. E. Mattsson, H. Elmqvist, and M. Otter, \"Physical system modeling with Modelica,\" Control Engineering Practice, vol. 6, pp. 501-510, 1998. </td>
	</tr>
	<tr>
		<td>[Mayerson1939]</td>
		<td>H. S. Mayerson, H. M. Sweeney, and L. A. Toth, THE INFLUENCE OF POSTURE ON CIRCULATION TIME vol. 125, 1939. </td>
	</tr>
	<tr>
		<td>[Mayerson1960]</td>
		<td>H. S. Mayerson, C. G. Wolfram, H. H. Shirley, and K. Wasserman, Regional differences in capillary permeability vol. 198, 1960. </td>
	</tr>
	<tr>
		<td>[Mayerson1960]</td>
		<td>H. S. Mayerson, C. G. Wolfram, H. H. Shirley, and K. Wasserman, Regional differences in capillary permeability vol. 198, 1960. </td>
	</tr>
	<tr>
		<td>[Mazzolai1999]</td>
		<td>L. Mazzolai, M. Maillard, J. Rossat, J. Nussberger, H. R. Brunner, and M. Burnier, \"Angiotensin II receptor blockade in normotensive subjects a direct comparison of three AT1 receptor antagonists,\" Hypertension, vol. 33, pp. 850-855, 1999. </td>
	</tr>
	<tr>
		<td>[McArdle2010]</td>
		<td>W. D. McArdle, F. I. Katch, and V. L. Katch, Exercise physiology: Nutrition, energy, and human performance: Lippincott Williams & Wilkins, 2010. </td>
	</tr>
	<tr>
		<td>[McGarry1976]</td>
		<td>J. D. McGarry and D. W. Foster, \"Ketogenesis and its regulation,\" The American Journal of Medicine, vol. 61, pp. 9-13, 1976. </td>
	</tr>
	<tr>
		<td>[McGarry1976]</td>
		<td>J. D. McGarry and D. W. Foster, \"Ketogenesis and its regulation,\" Am J Med, vol. 61, pp. 9-13, Jul 1976. </td>
	</tr>
	<tr>
		<td>[McGarry1975]</td>
		<td>J. McGarry, P. H. Wright, and D. W. Foster, \"Hormonal control of ketogenesis. Rapid activation of hepatic ketogenic capacity in fed rats by anti-insulin serum and glucagon,\" The Journal of Clinical Investigation, vol. 55, pp. 1202-1209, 1975. </td>
	</tr>
	<tr>
		<td>[McGarry1977]</td>
		<td>J. D. McGarry, G. P. Mannaerts, and D. W. Foster, \"A possible role for malonyl-CoA in the regulation of hepatic fatty acid oxidation and ketogenesis,\" The Journal of Clinical Investigation, vol. 60, pp. 265-270, 1977. </td>
	</tr>
	<tr>
		<td>[McKeever1958]</td>
		<td>W. McKeever, D. Gregg, and P. Canney, \"Oxygen uptake of the nonworking left ventricle,\" Circulation research, vol. 6, pp. 612-623, 1958. </td>
	</tr>
	<tr>
		<td>[MCKEEVER1958]</td>
		<td>W. P. MCKEEVER, D. E. GREGG, and P. C. CANNEY, \"Oxygen Uptake of the Nonworking Left Ventricle,\" Circulation Research, vol. 6, pp. 612-623, September 1, 1958 1958. </td>
	</tr>
	<tr>
		<td>[Mead1953]</td>
		<td>J. Mead and J. L. Whittenberger, Physical Properties of Human Lungs Measured During Spontaneous Respiration vol. 5, 1953. </td>
	</tr>
	<tr>
		<td>[Mellander1992]</td>
		<td>S. Mellander and J. Bjornberg, Regulation of Vascular Smooth Muscle Tone and Capillary Pressure vol. 7, 1992. </td>
	</tr>
	<tr>
		<td>[Mendelowitz1988]</td>
		<td>D. Mendelowitz and A. M. Scher, \"Pulsatile sinus pressure changes evoke sustained baroreflex responses in awake dogs,\" Am. J. Physiol, vol. 255, pp. H673-H678, 1988. </td>
	</tr>
	<tr>
		<td>[Metting1988]</td>
		<td>P. J. Metting, J. R. Strader, and S. L. Britton, Evaluation of whole body autoregulation in conscious dogs vol. 255, 1988. </td>
	</tr>
	<tr>
		<td>[Metting1989]</td>
		<td>P. J. Metting, P. M. Stein, B. A. Stoos, K. A. Kostrzewski, and S. L. Britton, Systemic vascular autoregulation amplifies pressor responses to vasoconstrictor agents vol. 256, 1989. </td>
	</tr>
	<tr>
		<td>[METZLER1986]</td>
		<td>C. H. METZLER, M.-E. LEE, T. N. THRASHER, and D. J. RAMSAY, \"Increased right or left atrial pressure stimulates release of atrial natriuretic peptides in conscious dogs,\" Endocrinology, vol. 119, pp. 2396-2398, 1986. </td>
	</tr>
	<tr>
		<td>[Mifflin1993]</td>
		<td>S. W. Mifflin, \"Inhibition of chemoreceptor inputs to nucleus of tractus solitarius neurons during baroreceptor stimulation,\" Am J Physiol, vol. 265, pp. R14-20, Jul 1993. </td>
	</tr>
	<tr>
		<td>[Michel1996]</td>
		<td>C. Michel, \"One hundred years of Starling's hypothesis,\" News in physiological sciences, vol. 11, pp. 229-237, 1996. </td>
	</tr>
	<tr>
		<td>[Miki1993]</td>
		<td>K. Miki, Y. Hayashida, and K. Shiraki, Cardiac-renal-neural reflex plays a major role in natriuresis induced by left atrial distension vol. 264, 1993. </td>
	</tr>
	<tr>
		<td>[Miki1989]</td>
		<td>K. Miki, Y. Hayashida, S. Sagawa, and K. Shiraki, Renal sympathetic nerve activity and natriuresis during water immersion in conscious dogs vol. 256, 1989. </td>
	</tr>
	<tr>
		<td>[Miki1989]</td>
		<td>K. Miki, Y. Hayashida, F. Tajima, J. Iwamoto, and K. Shiraki, Renal sympathetic nerve activity and renal responses during head-up tilt in conscious dogs vol. 257, 1989. </td>
	</tr>
	<tr>
		<td>[Miles1983]</td>
		<td>J. M. Miles and J. E. Gerich, \"Glucose and ketone body kinetics in diabetic ketoacidosis,\" Clin Endocrinol Metab, vol. 12, pp. 303-19, Jul 1983. </td>
	</tr>
	<tr>
		<td>[Miles1983]</td>
		<td>J. M. Miles and J. E. Gerich, \"Glucose and ketone body kinetics in diabetic ketoacidosis,\" Clin Endocrinol Metab, vol. 12, pp. 303-19, Jul 1983. </td>
	</tr>
	<tr>
		<td>[Miles1980]</td>
		<td>J. M. Miles, R. A. Rizza, M. W. Haymond, and J. E. Gerich, \"Effects of Acute Insulin Deficiency on Glucose and Ketone Body Turnover in Man: Evidence for the Primacy of Overproduction of Glucose and Ketone Bodies in the Genesis of Diabetic Ketoacidosis,\" Diabetes, vol. 29, pp. 926-930, November 1, 1980 1980. </td>
	</tr>
	<tr>
		<td>[Miles1995]</td>
		<td>P. D. Miles, M. Levisetti, D. Reichart, M. Khoursheed, A. Moossa, and J. M. Olefsky, \"Kinetics of insulin action in vivo: identification of rate-limiting steps,\" Diabetes, vol. 44, pp. 947-953, 1995. </td>
	</tr>
	<tr>
		<td>[Milledge1985]</td>
		<td>J. Milledge and P. Cotes, \"Serum erythropoietin in humans at high altitude and its relation to plasma renin,\" Journal of applied physiology (Bethesda, Md.: 1985), vol. 59, p. 360, 1985. </td>
	</tr>
	<tr>
		<td>[Miller1982]</td>
		<td>M. E. Miller, E. P. Cronkite, and J. F. Garcia, \"Plasma levels of immunoreactive erythropoietin after acute blood loss in man,\" British journal of haematology, vol. 52, pp. 545-549, 1982. </td>
	</tr>
	<tr>
		<td>[Miserocchi2001]</td>
		<td>G. Miserocchi, D. Negrini, A. Passi, and G. De Luca, Development of Lung Edema: Interstitial Fluid Dynamics and Molecular Structure vol. 16, 2001. </td>
	</tr>
	<tr>
		<td>[Mitzner1974]</td>
		<td>W. Mitzner, Hepatic outflow resistance, sinusoid pressure, and the vascular waterfall vol. 227, 1974. </td>
	</tr>
	<tr>
		<td>[Miura1977]</td>
		<td>Y. Miura, V. Campese, V. DeQuattro, and D. Meijer, \"Plasma catecholamines via an improved fluorimetric assay: comparison with an enzymatic method,\" J Lab Clin Med, vol. 89, pp. 421-427, 1977. </td>
	</tr>
	<tr>
		<td>[Mizelle1990]</td>
		<td>H. L. Mizelle, D. A. Hildebrandt, C. A. Gaillard, M. W. Brands, J.-P. Montani, M. J. Smith Jr, et al., \"Atrial natriuretic peptide induces sustained natriuresis in conscious dogs,\" American Journal of Physiology-Regulatory, Integrative and Comparative Physiology, vol. 258, pp. R1445-R1452, 1990. </td>
	</tr>
	<tr>
		<td>[Molnar1946]</td>
		<td>G. Molnar, \"Survival of hypothermia by men immersed in the ocean,\" Journal of the American Medical Association, vol. 131, pp. 1046-1050, 1946. </td>
	</tr>
	<tr>
		<td>[Monos2001]</td>
		<td>E. Monos, M. Lóránt, and E. Fehér, Influence of long-term experimental orthostatic body position on innervation density in extremity vessels vol. 281, 2001. </td>
	</tr>
	<tr>
		<td>[Monos2003]</td>
		<td>E. Monos, M. Lóránt, G. Dörnyei, V. Bérczi, and G. Nádasy, Long-Term Adaptation Mechanisms in Extremity Veins Supporting Orthostatic Tolerance vol. 18, 2003. </td>
	</tr>
	<tr>
		<td>[MONROE1960]</td>
		<td>R. G. MONROE and G. FRENCH, \"Ventricular Pressure-Volume Relationships and Oxygen Consumption in Fibrillation and Arrest,\" Circulation Research, vol. 8, pp. 260-266, January 1, 1960 1960. </td>
	</tr>
	<tr>
		<td>[MONROE1961]</td>
		<td>R. G. MONROE and G. N. FRENCH, \"Left ventricular pressure-volume relationships and myocardial oxygen consumption in the isolated heart,\" Circulation research, vol. 9, pp. 362-373, 1961. </td>
	</tr>
	<tr>
		<td>[Moore1990]</td>
		<td>L. C. Moore and D. Casellas, \"Tubuloglomerular feedback dependence of autoregulation in rat juxtamedullary afferent arterioles,\" Kidney Int, vol. 37, pp. 1402-1408, 06//print 1990. </td>
	</tr>
	<tr>
		<td>[Moore1959]</td>
		<td>E. W. Moore, M. L. Mitchell, and T. C. Chalmers, \"VARIABILITY IN ABSORPTION OF INSULIN-I131 IN NORMAL AND DIABETIC SUBJECTS AFTER SUBCUTANEOUS AND INTRAMUSCULAR INJECTION*,\" The Journal of Clinical Investigation, vol. 38, pp. 1222-1227, 1959. </td>
	</tr>
	<tr>
		<td>[Morgan1969]</td>
		<td>T. Morgan and R. W. Berliner, \"A Study by Continuous Microperfusion of Water and Electrolyte Movements in the Loop of Henle and Distal Tubule of the Rat,\" Nephron, vol. 6, pp. 388-405, 1969. </td>
	</tr>
	<tr>
		<td>[Morimoto1998]</td>
		<td>T. Morimoto and T. Itoh, \"Thermoregulation and body fluid osmolality,\" Journal of basic and clinical physiology and pharmacology, vol. 9, pp. 51-72, 1998. </td>
	</tr>
	<tr>
		<td>[Morita1985]</td>
		<td>H. Morita and S. F. Vatner, Effects of volume expansion on renal nerve activity, renal blood flow, and sodium and water excretion in conscious dogs vol. 249, 1985. </td>
	</tr>
	<tr>
		<td>[Morton1980]</td>
		<td>J. Morton, M. Tree, and J. Casals-Stenzel, \"The effect of captopril on blood pressure and angiotensins I, I1 and 111 in sodium-depleted dogs: problems associated with the measurement of angiotensin I1 after inhibition of converting enzyme,\" Clinical Science, vol. 58, p. 450, 1980. </td>
	</tr>
	<tr>
		<td>[Moses1972]</td>
		<td>S. W. Moses, N. Bashan, and A. Gutman, Glycogen Metabolism in the Normal Red Blood Cell vol. 40, 1972. </td>
	</tr>
	<tr>
		<td>[Moses1974]</td>
		<td>S. W. Moses, N. Bashan, A. Gutman, and P. A. Ockerman, Glycogen Metabolism in Glycogen-rich Erythrocytes vol. 44, 1974. </td>
	</tr>
[MüllerW. A. Müller, G. R. Faloona, and R. H. Unger, \"Hyperglucagonemia in diabetic ketoacidosis,\" The American Journal of Medicine, vol. 54, pp. 52-57.
	<tr>
		<td>[Murphy1960]</td>
		<td>J. Murphy, \"Erythrocyte metabolism,\" J Lah Clin Med, 1960. </td>
	</tr>
	<tr>
		<td>[Murphy2008]</td>
		<td>E. Murphy and C. Steenbergen, \"Ion transport and energetics during cell death and protection,\" Physiology (Bethesda), vol. 23, pp. 115-23, Apr 2008. </td>
	</tr>
	<tr>
		<td>[Myers2010]</td>
		<td>M. G. Myers Jr, R. L. Leibel, R. J. Seeley, and M. W. Schwartz, \"Obesity and leptin resistance: distinguishing cause from effect,\" Trends in Endocrinology & Metabolism, vol. 21, pp. 643-651, 11// 2010. </td>
	</tr>
	<tr>
		<td>[MYLLE1959]</td>
		<td>M. MYLLE, \"Localization of urine acidification in the mammalian kidney’j’,\" in Fed. Proc, 1959. </td>
	</tr>
	<tr>
		<td>[Neuhofer2006]</td>
		<td>W. Neuhofer and F.-X. Beck, Survival in Hostile Environments: Strategies of Renal Medullary Cells vol. 21, 2006. </td>
	</tr>
	<tr>
		<td>[Nicoloff1972]</td>
		<td>J. T. Nicoloff, J. C. Low, J. H. Dussault, and D. A. Fisher, \"Simultaneous Measurement of Thyroxine and Triiodothyronine Peripheral Turnover Kinetics in Man,\" The Journal of Clinical Investigation, vol. 51, pp. 473-483, 1972. </td>
	</tr>
	<tr>
		<td>[Nielsen1952]</td>
		<td>M. Nielsen and H. Smith, \"Studies on the Regulation of Respiration in Acute Hypoxia: With an Appendix on Kespiratory (Control During Prolonged Hypoxia,\" Acta Physiologica Scandinavica, vol. 24, pp. 293-313, 1952. </td>
	</tr>
	<tr>
		<td>[Nielsen1988]</td>
		<td>A. M. Nielsen, G. E. Bisgard, and E. H. Vidruk, Carotid chemoreceptor activity during acute and sustained hypoxia in goats vol. 65, 1988. </td>
	</tr>
	<tr>
		<td>[Nielsen2000]</td>
		<td>S. Nielsen, T.-H. Kwon, J. Frokiar, and M. A. Knepper, \"Key roles of renal aquaporins in water balance and water-balance disorders,\" Physiology, vol. 15, pp. 136-143, 2000. </td>
	</tr>
	<tr>
		<td>[Nicholls1987]</td>
		<td>M. Nicholls and A. Richards, \"Human studies with atrial natriuretic factor,\" Endocrinology and metabolism clinics of North America, vol. 16, pp. 199-223, 1987. </td>
	</tr>
	<tr>
		<td>[Nilsson2005]</td>
		<td>E. L. Nilsson and P. Fritzson, \"Biochemical and metabolic modeling and simulation with Modelica,\" BioMedSim. Linköping, Sweden, 2005. </td>
	</tr>
	<tr>
		<td>[Nilsson2005]</td>
		<td>E. L. Nilsson and P. Fritzson, \"A Metabolic Specialization of a General Purpose Modelica Library for Biological and Biochemical Systems,\" in Paper presented at the 4th International Modelica Conference, 2005. </td>
	</tr>
	<tr>
		<td>[Nishikimi1994]</td>
		<td>T. Nishikimi, K. Miura, N. Minamino, K. Takeuchi, and T. Takeda, Role of endogenous atrial natriuretic peptide on systemic and renal hemodynamics in heart failure rats vol. 267, 1994. </td>
	</tr>
	<tr>
		<td>[NODA1993]</td>
		<td>T. NODA, C.-P. CHENG, P. P. DE TOMBE, and W. C. LITTLE, \"Curvilinearity of LV end-systolic pressure-volume and dP/dt,-end-diastolic volume relations,\" 1993. </td>
	</tr>
	<tr>
		<td>[O’ROURKE1990]</td>
		<td>S. T. O’ROURKE and P. M. VANHOUTTE, \"Adrenergic and cholinergic responsiveness of isolated canine bronchial arteries,\" Organ, vol. 6, p. 2, 1990. </td>
	</tr>
	<tr>
		<td>[Oelkers1978]</td>
		<td>W. Oelkers, M. Schöneshöfer, G. Schultze, and B. Bauer, \"Effect of prolonged low-dose infusions of ile5-angiotensin II on blood pressure, aldosterone and electrolyte excretion in sodium replete man,\" Klinische Wochenschrift, vol. 56, pp. 37-41, 1978/01/01 1978. </td>
	</tr>
	<tr>
		<td>[Oelkers1974]</td>
		<td>W. Oelkers, J. J. Brown, R. Fraser, A. F. Lever, J. J. MORTON, and J. I. S. ROBERTSON, \"Sensitization of the adrenal cortex to angiotensin II in sodium-deplete man,\" Circulation research, vol. 34, pp. 69-77, 1974. </td>
	</tr>
	<tr>
		<td>[Oelkers1974]</td>
		<td>W. Oelkers, J. J. Brown, R. Fraser, A. F. Lever, J. J. MORTON, and J. I. S. ROBERTSON, \"Sensitization of the adrenal cortex to angiotensin II in sodium-deplete man,\" Circulation research, vol. 34, pp. 69-77, 1974. </td>
	</tr>
	<tr>
		<td>[Ohneda1969]</td>
		<td>A. Ohneda, E. Aguilar-Parada, A. M. Eisentraut, and R. H. Unger, \"Control of Pancreatic Glucagon S"
             + "ecretion by Glucose,\" Diabetes, vol. 18, pp. 1-10, January 1, 1969 1969. </td>
	</tr>
	<tr>
		<td>[OCHSNER1951]</td>
		<td>A. OCHSNER, R. COLP, and G. E. BURCH, \"Normal Blood Pressure in the Superficial Venous System of Man at Rest in the Supine Position,\" Circulation, vol. 3, pp. 674-680, May 1, 1951 1951. </td>
	</tr>
	<tr>
		<td>[Olsen1985]</td>
		<td>M. E. Olsen, J. E. Hall, J.-P. Montani, A. C. Guyton, H. G. Langford, and J. E. Cornell, \"Mechanisms of angiotensin II natriuresis and antinatriuresis,\" Am J Physiol, vol. 249, pp. F299-F307, 1985. </td>
	</tr>
	<tr>
		<td>[Olszewski1980]</td>
		<td>W. L. Olszewski and A. Engeset, Intrinsic contractility of prenodal lymph vessels and lymph flow in human leg vol. 239, 1980. </td>
	</tr>
	<tr>
		<td>[Orešković2010]</td>
		<td>D. Orešković and M. Klarica, \"The formation of cerebrospinal fluid: nearly a hundred years of interpretations and misinterpretations,\" Brain research reviews, vol. 64, pp. 241-262, 2010. </td>
	</tr>
	<tr>
		<td>[Orloff1973]</td>
		<td>J. Orloff, R. W. Berliner, and S. R. Geiger, Handbook of Physiology: Section 8, Renal Physiology: American Physiological Society, 1973. </td>
	</tr>
	<tr>
		<td>[Osiba1957]</td>
		<td>S. Osiba, \"THE SEASONAL VARIATION OF BASAL METABOLISM AND ACTIVITY OF THYROID GLAND IN MAN,\" The Japanese Journal of Physiology, vol. 7, pp. 355-365, 1957. </td>
	</tr>
	<tr>
		<td>[Owen1967]</td>
		<td>O. E. Owen, A. P. Morgan, H. G. Kemp, J. M. Sullivan, M. G. Herrera, and G. F. Cahill, Jr., \"Brain Metabolism during Fasting*,\" The Journal of Clinical Investigation, vol. 46, pp. 1589-1595, 1967. </td>
	</tr>
	<tr>
		<td>[Owen1967]</td>
		<td>O. E. Owen, A. P. Morgan, H. G. Kemp, J. M. Sullivan, M. G. Herrera, and G. F. Cahill, Jr., \"Brain Metabolism during Fasting*,\" The Journal of Clinical Investigation, vol. 46, pp. 1589-1595, 1967. </td>
	</tr>
	<tr>
		<td>[Owen1983]</td>
		<td>O. E. Owen, S. Caprio, G. A. Reichard, Jr., M. A. Mozzoli, G. Boden, and R. S. Owen, \"Ketosis of starvation: a revisit and new perspectives,\" Clin Endocrinol Metab, vol. 12, pp. 359-79, Jul 1983. </td>
	</tr>
	<tr>
		<td>[Pack1993]</td>
		<td>A. Pack and A. Gottschalk, \"Mechanisms of ventilatory periodicities,\" Annals of Biomedical Engineering, vol. 21, pp. 537-544, 1993/09/01 1993. </td>
	</tr>
	<tr>
		<td>[Pagel1988]</td>
		<td>H. Pagel, W. Jelkmann, and C. Weiss, \"A comparison of the effects of renal artery constriction and anemia on the production of erythropoietin,\" Pflügers Archiv, vol. 413, pp. 62-66, 1988/11/01 1988. </td>
	</tr>
	<tr>
		<td>[Palm2013]</td>
		<td>H. Palm, J. Holzmann, R. Klein, S.-A. Schneider, and D. Gerling, \"A Novel Approach on Virtual Systems Prototyping Based on a Validated, Hierarchical, Modular Library,\" Embedded World, Nuremberg, Germany, 2013. </td>
	</tr>
	<tr>
		<td>[Pare1982]</td>
		<td>P. D. Pare, L. A. Brooks, J. Bates, L. M. Lawson, J. M. Nelems, J. L. Wright, et al., \"Exponential analysis of the lung pressure-volume curve as a predictor of pulmonary emphysema,\" The American review of respiratory disease, vol. 126, pp. 54-61, 1982/07// 1982. </td>
	</tr>
	<tr>
		<td>[Park1998]</td>
		<td>F. Park, A.-P. Zou, and A. W. Cowley, \"Arginine vasopressin–mediated stimulation of nitric oxide within the rat renal medulla,\" Hypertension, vol. 32, pp. 896-901, 1998. </td>
	</tr>
	<tr>
		<td>[Pedersen1975]</td>
		<td>E. B. Pedersen and N. Christensen, \"Catecholamines in Plasma and Urine in Patients with Essential Hypertension Determined by Double-Isotope Derivative Techniques,\" Acta Medica Scandinavica, vol. 198, pp. 373-377, 1975. </td>
	</tr>
	<tr>
		<td>[Pennes1948]</td>
		<td>H. H. Pennes, Analysis of Tissue and Arterial Blood Temperatures in the Resting Human Forearm vol. 1, 1948. </td>
	</tr>
	<tr>
		<td>[Perley1966]</td>
		<td>M. Perley and D. M. Kipnis, \"Plasma Insulin Responses to Glucose and Tolbutamide of Normal Weight and Obese Diabetic and Nondiabetic Subjects,\" Diabetes, vol. 15, pp. 867-874, December 1, 1966 1966. </td>
	</tr>
	<tr>
		<td>[Permutt1960]</td>
		<td>S. Permutt and H. B. Martin, Static pressure-volume characteristics of lungs in normal males vol. 15, 1960. </td>
	</tr>
	<tr>
		<td>[Peti-Peterdi2009]</td>
		<td>J. Peti-Peterdi, I. Toma, A. Sipos, and S. L. Vargas, \"Multiphoton imaging of renal regulatory mechanisms,\" Physiology, vol. 24, pp. 88-96, 2009. </td>
	</tr>
	<tr>
		<td>[Pfaller1982]</td>
		<td>W. Pfaller, \"Structure function correlation on rat kidney,\" Adv Anat Embryol Cell Biol, vol. 70, 1982. </td>
	</tr>
	<tr>
		<td>[PHILIPPOPOULOS1959]</td>
		<td>G. S. PHILIPPOPOULOS, \"THYROTOXICOSIS AND ITS PSYCHOSOMATIC APPROACH 1,\" The Journal of Nervous and Mental Disease, vol. 128, pp. 415-424, 1959. </td>
	</tr>
	<tr>
		<td>[Pico2003]</td>
		<td>C. Pico, P. Oliver, J. Sanchez, and A. Palou, \"Gastric leptin: a putative role in the short-term regulation of food intake,\" British Journal of Nutrition, vol. 90, pp. 735-741, 2003. </td>
	</tr>
	<tr>
		<td>[Pierson1974]</td>
		<td>R. Pierson Jr, D. Lin, and R. Phillips, \"Total-body potassium in health: effects of age, sex, height, and fat,\" American Journal of Physiology--Legacy Content, vol. 226, pp. 206-212, 1974. </td>
	</tr>
	<tr>
		<td>[Piwonka1967]</td>
		<td>R. W. Piwonka and S. Robinson, Acclimatization of highly trained men to work in severe heat vol. 22, 1967. </td>
	</tr>
	<tr>
		<td>[Pogátsa1982]</td>
		<td>G. Pogátsa, M. Z. Koltai, and G. Grósz, \"The role of the myocardial water content in heart function,\" Acta physiologica Academiae Scientiarum Hungaricae, vol. 59, pp. 305-309, 1982 1982. </td>
	</tr>
	<tr>
		<td>[POHOST1976]</td>
		<td>G. M. POHOST, J. B. NEWELL, N. P. HAMLIN, and W. J. POWELL, \"Observations on autoregulation in skeletal muscle: the effects of arterial hypoxia,\" Cardiovascular Research, vol. 10, pp. 405-412, July 1, 1976 1976. </td>
	</tr>
	<tr>
		<td>[Pollack1949]</td>
		<td>A. A. Pollack and E. H. Wood, Venous Pressure in the Saphenous Vein at the Ankle in Man during Exercise and Changes in Posture vol. 1, 1949. </td>
	</tr>
	<tr>
		<td>[Porter1993]</td>
		<td>D. Porter and M. Goldberg, \"Regulation of erythropoietin production,\" Experimental hematology, vol. 21, pp. 399-404, 1993. </td>
	</tr>
	<tr>
		<td>[Potts1993]</td>
		<td>J. T. Potts, X. R. Shi, and P. B. Raven, \"Carotid baroreflex responsiveness during dynamic exercise in humans,\" American Journal of Physiology, vol. 265, pp. H1928-H1928, 1993. </td>
	</tr>
	<tr>
		<td>[Powell1983]</td>
		<td>F. L. Powell and R. W. Mazzone, \"Morphometrics of rapidly frozen goose lungs,\" Respir Physiol, vol. 51, pp. 319-32, Mar 1983. </td>
	</tr>
	<tr>
		<td>[Prabhu1993]</td>
		<td>S. D. Prabhu and G. L. Freeman, \"Left ventricular energetics in closed-chest dogs,\" Am J Physiol, vol. 265, pp. H1048-55, Oct 1993. </td>
	</tr>
	<tr>
		<td>[Prager1986]</td>
		<td>R. Prager, P. Wallace, and J. M. Olefsky, \"In vivo kinetics of insulin action on peripheral glucose disposal and hepatic glucose output in normal and obese subjects,\" Journal of Clinical Investigation, vol. 78, p. 472, 1986. </td>
	</tr>
	<tr>
		<td>[Prager1986]</td>
		<td>R. Prager, P. Wallace, and J. M. Olefsky, \"In vivo kinetics of insulin action on peripheral glucose disposal and hepatic glucose output in normal and obese subjects,\" The Journal of Clinical Investigation, vol. 78, pp. 472-481, 1986. </td>
	</tr>
	<tr>
		<td>[Prager1987]</td>
		<td>R. Prager, P. Wallace, and J. M. Olefsky, \"Hyperinsulinemia does not compensate for peripheral insulin resistance in obesity,\" Diabetes, vol. 36, pp. 327-334, 1987. </td>
	</tr>
	<tr>
		<td>[Prager1987]</td>
		<td>R. Prager, P. Wallace, and J. M. Olefsky, \"Hyperinsulinemia Does Not Compensate for Peripheral Insulin Resistance in Obesity,\" Diabetes, vol. 36, pp. 327-334, March 1, 1987 1987. </td>
	</tr>
	<tr>
		<td>[Previs2000]</td>
		<td>S. F. Previs, D. J. Withers, J. M. Ren, M. F. White, and G. I. Shulman, \"Contrasting effects of IRS-1 versus IRS-2 gene disruption on carbohydrate and lipid metabolism in vivo,\" J Biol Chem, vol. 275, pp. 38990-4, Dec 15 2000. </td>
	</tr>
	<tr>
		<td>[Prewitt1976]</td>
		<td>R. L. Prewitt and P. C. Johnson, \"The effect of oxygen on arteriolar red cell velocity and capillary density in the rat cremaster muscle,\" Microvascular Research, vol. 12, pp. 59-70, 7// 1976. </td>
	</tr>
[PrivitzerJ. K. M. M. P. Privitzer, \"HumMod-Large Scale Physiological Models in Modelica.\"
[PrivitzerP. Privitzer, J. Šilar, T. Kulhánek, M. Mateják, and J. Kofránek, \"Simulation Applications in Medical Education.\"
	<tr>
		<td>[Proß2011]</td>
		<td>S. Proß and B. Bachmann, \"An Advanced Environment for Hybrid Modeling and Parameter Identification of Biological Systems,\" 2011. </td>
	</tr>
	<tr>
		<td>[Pruett2014]</td>
		<td>W. A. Pruett and R. L. Hester, \"Parathyroid hormone secretion by multiple distinct cell populations, a time dynamic mathematical model,\" Physiological reports, vol. 2, 2014. </td>
	</tr>
	<tr>
		<td>[Pruett2013]</td>
		<td>W. A. Pruett, L. D. Husband, G. Husband, M. Dakhlalla, K. Bellamy, T. G. Coleman, et al., \"A Population Model of Integrative Cardiovascular Physiology,\" PloS one, vol. 8, p. e74329, 2013. </td>
	</tr>
	<tr>
		<td>[Pruett2013]</td>
		<td>W. A. Pruett, L. D. Husband, G. Husband, M. Dakhlalla, K. Bellamy, T. G. Coleman, et al., \"A Population Model of Integrative Cardiovascular Physiology,\" PloS one, vol. 8, p. e74329, 2013. </td>
	</tr>
	<tr>
		<td>[Puceat1999]</td>
		<td>M. Puceat, \"pHi regulatory ion transporters: an update on structure, regulation and cell function,\" Cell Mol Life Sci, vol. 55, pp. 1216-29, Aug 15 1999. </td>
	</tr>
	<tr>
		<td>[Purves1970]</td>
		<td>M. J. Purves, \"The effect of hypoxia, hypercapnia and hypotension upon carotid body blood flow and oxygen consumption in the cat,\" The Journal of Physiology, vol. 209, pp. 395-416, August 1, 1970 1970. </td>
	</tr>
	<tr>
		<td>[Quinton1991]</td>
		<td>P. Quinton and M. Reddy, \"Regulation of absorption in the human sweat duct,\" in The Identification of the CF (Cystic Fibrosis) Gene, ed: Springer, 1991, pp. 159-172. </td>
	</tr>
	<tr>
		<td>[Rabie2008]</td>
		<td>T. Rabie and H. H. Marti, Brain Protection by Erythropoietin: A Manifold Task vol. 23, 2008. </td>
	</tr>
	<tr>
		<td>[Raeder1995]</td>
		<td>E. A. Raeder, P. Albrecht, M. Perrott, and R. J. Cohen, \"Kinetics of Cycle Length Dependence of Ventricular Repolarization,\" Journal of Cardiovascular Electrophysiology, vol. 6, pp. 163-169, 1995. </td>
	</tr>
	<tr>
		<td>[Rahmouni2002]</td>
		<td>K. Rahmouni, W. G. Haynes, and A. L. Mark, \"Cardiovascular and sympathetic effects of leptin,\" Current hypertension reports, vol. 4, pp. 119-125, 2002. </td>
	</tr>
	<tr>
		<td>[Rahn1946]</td>
		<td>H. Rahn, A. B. Otis, L. E. Chadwick, and W. O. Fenn, THE PRESSURE-VOLUME DIAGRAM OF THE THORAX AND LUNG vol. 146, 1946. </td>
	</tr>
	<tr>
		<td>[Raine1986]</td>
		<td>A. E. Raine, P. Erne, E. Bürgisser, F. B. Müller, P. Bolli, F. Burkart, et al., \"Atrial natriuretic peptide and atrial pressure in patients with congestive heart failure,\" New England Journal of Medicine, vol. 315, pp. 533-537, 1986. </td>
	</tr>
	<tr>
		<td>[Randle1986]</td>
		<td>P. J. Randle, \"Fuel selection in animals,\" Biochemical Society Transactions, vol. 14, p. 799, 1986. </td>
	</tr>
	<tr>
		<td>[Rappaport1973]</td>
		<td>A. M. Rappaport, \"The microcirculatory hepatic unit,\" Microvascular Research, vol. 6, pp. 212-228, 9// 1973. </td>
	</tr>
	<tr>
		<td>[Raskin1975]</td>
		<td>P. Raskin, Y. Fujita, and R. H. Unger, \"Effect of insulin-glucose infusions on plasma glucagon levels in fasting diabetics and nondiabetics,\" The Journal of Clinical Investigation, vol. 56, pp. 1132-1138, 1975. </td>
	</tr>
	<tr>
		<td>[Rasmussen1999]</td>
		<td>B. B. Rasmussen and R. R. Wolfe, \"Regulation of fatty acid oxidation in skeletal muscle,\" Annual review of nutrition, vol. 19, pp. 463-484, 1999. </td>
	</tr>
	<tr>
		<td>[Raven1984]</td>
		<td>P. B. Raven, D. Rohm-Young, and C. G. Blomqvist, Physical fitness and cardiovascular response to lower body negative pressure vol. 56, 1984. </td>
	</tr>
	<tr>
		<td>[Reed1993]</td>
		<td>R. K. Reed, M. Ishibashi, M. Townsley, J. Parker, and A. Taylor, \"Blood-to-tissue clearance vs. lymph analysis in determining capillary transport characteristics for albumin in skin,\" AMERICAN JOURNAL OF PHYSIOLOGY, vol. 264, pp. H1394-H1394, 1993. </td>
	</tr>
	<tr>
		<td>[Regoli1962]</td>
		<td>D. Regoli, R. Hess, H. Brunner, G. Peters, and F. Gross, \"Interrelationship of renin content in kidneys and blood pressure in renal hypertensive rats,\" Archives internationales de pharmacodynamie et de thérapie, vol. 140, p. 416, 1962. </td>
	</tr>
	<tr>
		<td>[Reid1980]</td>
		<td>J. L. Reid, D. H. Jones, G. Fitzgerald, D. Davies, and A. Boobis, \"Catecholamine Turnover in Essential Hypertension,\" Clinical and Experimental Hypertension, vol. 2, pp. 395-408, 1980. </td>
	</tr>
	<tr>
		<td>[Reichard1974]</td>
		<td>G. A. Reichard, Jr., O. E. Owen, A. C. Haff, P. Paul, and W. M. Bortz, \"Ketone-body production and oxidation in fasting obese humans,\" The Journal of Clinical Investigation, vol. 53, pp. 508-515, 1974. </td>
	</tr>
	<tr>
		<td>[Reissmann1965]</td>
		<td>K. R. Reissmann, D. A. Diederich, K. Ito, and J. Schmaus, \"Influence of disappearance rate and distribution space on plasma concentration of erythropoietin in normal rats,\" J Lab Clin Med, vol. 65, pp. 967-975, 1965. </td>
	</tr>
	<tr>
		<td>[Reivich1964]</td>
		<td>M. Reivich, Arterial Pco2 and cerebral hemodynamics vol. 206, 1964. </td>
	</tr>
	<tr>
		<td>[Renkin1986]</td>
		<td>E. M. Renkin, Some consequences of capillary permeability to macromolecules: Starling's hypothesis reconsidered vol. 250, 1986. </td>
	</tr>
	<tr>
		<td>[Renkin1996]</td>
		<td>E. M. Renkin and V. L. Tucker, \"Atria1 Natriuretic Peptide as a Regulator of Transvascdar Fluid Balance,\" 1996. </td>
	</tr>
	<tr>
		<td>[Renkin1996]</td>
		<td>E. Renkin and V. Tucker, \"Atrial Natriuretic Peptide as a Regulator of Transvascular Fluid Balance,\" Physiology, vol. 11, pp. 138-143, 1996. </td>
	</tr>
	<tr>
		<td>[Renkin1992]</td>
		<td>E. M. Renkin, V. Tucker, K. Rew, D. O'Loughlin, M. Wong, and L. Sibley, Plasma volume expansion with colloids increases blood-tissue albumin transport vol. 262, 1992. </td>
	</tr>
	<tr>
		<td>[Ridgway1974]</td>
		<td>E. C. Ridgway, B. D. Weintraub, and F. Maloof, \"Metabolic Clearance and Production Rates of Human Thyrotropin,\" The Journal of Clinical Investigation, vol. 53, pp. 895-903, 1974. </td>
	</tr>
	<tr>
		<td>[Risöe1994]</td>
		<td>C. Risöe, W. Tan, and O. A. Smiseth, \"Effect of carotid sinus baroreceptor reflex on hepatic and splenic vascular capacitance in vagotomized dogs,\" AMERICAN JOURNAL OF PHYSIOLOGY, vol. 266, pp. H1528-H1528, 1994. </td>
	</tr>
	<tr>
		<td>[Roach1957]</td>
		<td>M. R. Roach and A. C. Burton, \"THE REASON FOR THE SHAPE OF THE DISTENSIBILITY CURVES OF ARTERIES,\" Canadian Journal of Biochemistry and Physiology, vol. 35, pp. 681-690, 1957/08/01 1957. </td>
	</tr>
	<tr>
		<td>[Roarty1988]</td>
		<td>T. P. Roarty and H. Raff, \"Renin response to graded haemorrhage in conscious rats,\" Clinical and Experimental Pharmacology and Physiology, vol. 15, pp. 373-378, 1988. </td>
	</tr>
	<tr>
		<td>[Robin1958]</td>
		<td>E. D. Robin, R. D. Whaley, C. H. Crump, A. G. Bickelmann, and D. M. Travis, Acid-Base Relations Between Spinal Fluid and Arterial Blood With Special Reference to Control of Ventilation vol. 13, 1958. </td>
	</tr>
	<tr>
		<td>[Roblitz2013]</td>
		<td>S. Roblitz, C. Stotzel, P. Deuflhard, H. M. Jones, D. O. Azulay, P. H. van der Graaf, et al., \"A mathematical model of the human menstrual cycle for the administration of GnRH analogues,\" J Theor Biol, vol. 321, pp. 8-27, Mar 21 2013. </td>
	</tr>
	<tr>
		<td>[Röblitz2013]</td>
		<td>S. Röblitz, C. Stötzel, P. Deuflhard, H. M. Jones, D.-O. Azulay, P. H. van der Graaf, et al., \"A mathematical model of the human menstrual cycle for the administration of GnRH analogues,\" Journal of theoretical biology, vol. 321, pp. 8-27, 2013. </td>
	</tr>
	<tr>
		<td>[Rodgers1998]</td>
		<td>C. D. Rodgers and M. Vranic, \"Mediation of glucoregulation at rest and during exercise by the glucose-fatty acid cycle: in vivo and in vitro studies,\" Canadian journal of applied physiology, vol. 23, pp. 534-557, 1998. </td>
	</tr>
	<tr>
		<td>[Rodriguez-Nichols1984]</td>
		<td>F. Rodriguez-Nichols, E. Laughrey, and R. L. Tannen, Response of renal NH3 production to chronic respiratory acidosis vol. 247, 1984. </td>
	</tr>
	<tr>
		<td>[Rogers1993]</td>
		<td>R. F. Rogers, J. F. Paton, and J. S. Schwaber, \"NTS neuronal responses to arterial pressure and pressure changes in the rat,\" American Journal of Physiology, vol. 265, pp. R1355-R1355, 1993. </td>
	</tr>
	<tr>
		<td>[Roos1971]</td>
		<td>A. Roos, \"Intracellular pH and buffering power of rat brain,\" Am J Physiol, vol. 221, pp. 176-81, Jul 1971. </td>
	</tr>
	<tr>
		<td>[ROSS1965]</td>
		<td>J. ROSS, J. W. LINHART, and E. BRAUNWALD, \"Effects of Changing Heart Rate in Man by Electrical Stimulation of the Right Atrium: Studies at Rest, during Exercise, and with Isoproterenol,\" Circulation, vol. 32, pp. 549-558, October 1, 1965 1965. </td>
	</tr>
	<tr>
		<td>[Rother1998]</td>
		<td>K. I. Rother, Y. Imai, M. Caruso, F. Beguinot, P. Formisano, and D. Accili, \"Evidence That IRS-2 Phosphorylation Is Required for Insulin Action in Hepatocytes,\" Journal of Biological Chemistry, vol. 273, pp. 17491-17497, July 10, 1998 1998. </td>
	</tr>
	<tr>
		<td>[Rothman1991]</td>
		<td>D. L. Rothman, I. Magnusson, L. D. Katz, R. G. Shulman, and G. I. Shulman, \"Quantitation of hepatic glycogenolysis and gluconeogenesis in fasting humans with 13C NMR,\" Science, vol. 254, pp. 573-576, 1991. </td>
	</tr>
	<tr>
		<td>[Roush1995]</td>
		<td>W. Roush, \"An \"off switch\" for red blood cells,\" Science, vol. 268, pp. 27-28, April 7, 1995 1995. </td>
	</tr>
	<tr>
		<td>[Rowell1989]</td>
		<td>L. B. Rowell, D. G. Johnson, P. B. Chase, K. A. Comess, and D. R. Seals, Hypoxemia raises muscle sympathetic activity but not norepinephrine in resting humans vol. 66, 1989. </td>
	</tr>
	<tr>
		<td>[Ruderman2001]</td>
		<td>N. Ruderman and J. S. Flier, \"Chewing the Fat--ACC and Energy Balance,\" Science, vol. 291, pp. 2558-2559, March 30, 2001 2001. </td>
	</tr>
	<tr>
		<td>[Ruskoaho1992]</td>
		<td>H. Ruskoaho, \"Atrial natriuretic peptide: synthesis, release, and metabolism,\" Pharmacological Reviews, vol. 44, pp. 479-602, 1992. </td>
	</tr>
	<tr>
		<td>[Rutter2006]</td>
		<td>G. A. Rutter and E. V. Hill, Insulin Vesicle Release: Walk, Kiss, Pause … Then Run vol. 21, 2006. </td>
	</tr>
	<tr>
		<td>[Sagawa1988]</td>
		<td>K. Sagawa, L. Maughan, H. Suga, and K. Sunagawa, Cardiac contraction and the pressure-volume relationship vol. 480: Oxford University Press New York, 1988. </td>
	</tr>
	<tr>
		<td>[Sage1981]</td>
		<td>J. I. Sage, R. L. Van Uitert, and T. E. Duffy, \"Simultaneous Measurement of Cerebral Blood Flow and Unidirectional Movement of Substances Across the Blood-Brain Barrier: Theory, Method, and Application to Leucine,\" Journal of Neurochemistry, vol. 36, pp. 1731-1738, 1981. </td>
	</tr>
	<tr>
		<td>[Saltin1966]</td>
		<td>B. Saltin and L. Hermansen, Esophageal, rectal, and muscle temperature during exercise vol. 21, 1966. </td>
	</tr>
	<tr>
		<td>[Sands1999]</td>
		<td>J. M. Sands, Urea Transport: It’s Not Just “Freely Diffusible” Anymore vol. 14, 1999. </td>
	</tr>
	<tr>
		<td>[Sartorius1949]</td>
		<td>O. Sartorius, J. Roemmelt, R. Pitts, D. Calhoon, and P. Miner, \"The renal regulation of acid-base balance in man. IV. The nature of the renal compensations in ammonium chloride acidosis,\" Journal of Clinical Investigation, vol. 28, p. 423, 1949. </td>
	</tr>
	<tr>
		<td>[Sasaki1985]</td>
		<td>S. Sasaki, T. Shiigai, and J. Takeuchi, \"Intracellular pH in the isolated perfused rabbit proximal straight tubule,\" Am. J. Physiol, vol. 249, pp. F417-F423, 1985. </td>
	</tr>
	<tr>
		<td>[Sato1977]</td>
		<td>K. Sato, \"The physiology, pharmacology, and biochemistry of the eccrine sweat gland,\" in Reviews of Physiology, Biochemistry and Pharmacology, Volume 79, ed: Springer, 1977, pp. 51-131. </td>
	</tr>
	<tr>
		<td>[Sato1989]</td>
		<td>K. Sato, W. Kang, K. Saga, and K. Sato, \"Biology of sweat glands and their disorders. I. Normal sweat gland function,\" Journal of the American Academy of Dermatology, vol. 20, pp. 537-563, 1989. </td>
	</tr>
	<tr>
		<td>[Sato1989]</td>
		<td>K. Sato, W. Kang, K. Saga, and K. Sato, \"Biology of sweat glands and their disorders. II. Disorders of sweat gland function,\" Journal of the American Academy of Dermatology, vol. 20, pp. 713-726, 1989. </td>
	</tr>
	<tr>
		<td>[Sato1996]</td>
		<td>A. Sato, Y. Sato, A. Suzuki, and S. Uchida, \"Reflex modulation of catecholamine secretion and adrenal sympathetic nerve activity by acupuncture-like stimulation in anesthetized rat,\" Jpn J Physiol, vol. 46, pp. 411-21, Oct 1996. </td>
	</tr>
	<tr>
		<td>[Savin1983]</td>
		<td>V. J. Savin, \"Ultrafiltration in single isolated human glomeruli,\" Kidney Int, vol. 24, pp. 748-753, 12//print 1983. </td>
	</tr>
	<tr>
		<td>[Seals1991]</td>
		<td>D. R. Seals, D. G. Johnson, and R. F. Fregosi, \"Hyperoxia lowers sympathetic activity at rest but not during exercise in humans,\" Am J Physiol, vol. 260, pp. R873-8, May 1991. </td>
	</tr>
	<tr>
		<td>[Seeliger1999]</td>
		<td>E. Seeliger, K. Lohmann, B. Nafz, P. B. Persson, and H. W. Reinhardt, \"Pressure-dependent renin release: effects of sodium intake and changes of total body sodium,\" American Journal of Physiology-Regulatory, Integrative and Comparative Physiology, vol. 277, pp. R548-R555, 1999. </td>
	</tr>
	<tr>
		<td>[Sheiner1977]</td>
		<td>L. Sheiner, B. Rosenberg, and V. Marathe, \"Estimation of population characteristics of pharmacokinetic parameters from routine clinical data,\" Journal of Pharmacokinetics and Biopharmaceutics, vol. 5, pp. 445-479, 1977/10/01 1977. </td>
	</tr>
	<tr>
		<td>[Shek1998]</td>
		<td>E. W. Shek, M. W. Brands, and J. E. Hall, \"Chronic Leptin Infusion Increases Arterial Pressure,\" Hypertension, vol. 31, pp. 409-414, January 1, 1998 1998. </td>
	</tr>
	<tr>
		<td>[Sherwood2004]</td>
		<td>L. Sherwood and C. Learning, \"Human physiology: from cells to systems,\" 2004. </td>
	</tr>
	<tr>
		<td>[Shigemi1994]</td>
		<td>K. Shigemi, M. J. Brunner, and A. A. Shoukas, \"-and -Adrenergic mechanisms in the control of vascular capacitance by the carotid sinus baroreflex system,\" AMERICAN JOURNAL OF PHYSIOLOGY, vol. 267, pp. H201-H201, 1994. </td>
	</tr>
	<tr>
		<td>[ScHADE1975]</td>
		<td>D. S. ScHADE and R. Eaton, \"Glucagon regulation of plasma ketone body concentration in human diabetes,\" Journal of Clinical Investigation, vol. 56, p. 1340, 1975. </td>
	</tr>
	<tr>
		<td>[Schade1975]</td>
		<td>D. S. Schade and R. P. Eaton, \"Glucagon regulation of plasma ketone body concentration in human diabetes,\" The Journal of Clinical Investigation, vol. 56, pp. 1340-1344, 1975. </td>
	</tr>
	<tr>
		<td>[Schaefer1958]</td>
		<td>K. E. Schaefer, Respiratory Pattern and Respiratory Response to CO2 vol. 13, 1958. </td>
	</tr>
	<tr>
		<td>[Schally1966]</td>
		<td>A. V. Schally, C. Y. Bowers, T. W. Redding, and J. F. Barrett, \"Isolation of thyrotropin releasing factor (TRF) from porcine hypothalamus,\" Biochem Biophys Res Commun, vol. 25, pp. 165-9, Oct 20 1966. </td>
	</tr>
	<tr>
		<td>[Schling2002]</td>
		<td>P. Schling and G. Löffler, \"Cross talk between adipose tissue cells: impact on pathophysiology,\" Physiology, vol. 17, pp. 99-104, 2002. </td>
	</tr>
	<tr>
		<td>[Schmid-Schonbein1990]</td>
		<td>G. W. Schmid-Schonbein, Microlymphatics and lymph flow vol. 70, 1990. </td>
	</tr>
	<tr>
		<td>[SCHNEIDER1985]</td>
		<td>E. G. SCHNEIDER, K. J. RADKE, D. A. ULDERICH, and R. E. TAYLOR JR, \"Effect of Osmolality on Aldosterone Secretion*,\" Endocrinology, vol. 116, pp. 1621-1626, 1985. </td>
	</tr>
	<tr>
		<td>[Scholer1973]</td>
		<td>D. Scholer, M. Birkhäuser, A. Peytremann, A. Riondel, M. Vallotton, and A. Muller, \"Response of plasma aldosterone to angiotensin II, ACTH and potassium in man,\" Acta endocrinologica, vol. 72, pp. 293-307, 1973. </td>
	</tr>
	<tr>
		<td>[Schreiber1996]</td>
		<td>M. Schreiber, A. Steele, J. Goguen, A. Levin, and M. Halperin, \"Can a severe degree of ketoacidosis develop overnight?,\" Journal of the American Society of Nephrology, vol. 7, pp. 192-7, February 1, 1996 1996. </td>
	</tr>
	<tr>
		<td>[Schreider1957]</td>
		<td>E. Schreider, \"Ecological Rules and Body-heat Regulation in Man,\" Nature, vol. 179, pp. 915-916, 05/04/print 1957. </td>
	</tr>
	<tr>
		<td>[Schreij1996]</td>
		<td>G. Schreij, P. N. van Es, P. M. Schiffers, and P. W. de Leeuw, \"Renal extraction of atrial natriuretic peptide in hypertensive patients with or without renal artery stenosis,\" Hypertension, vol. 27, pp. 1254-1258, 1996. </td>
	</tr>
	<tr>
		<td>[Schrier1970]</td>
		<td>R. W. Schrier, K. M. McDonald, R. Wells, and D. P. Lauler, \"Influence of hematocrit and colloid on whole blood viscosity during volume expansion,\" Am. J. Physiol, vol. 218, p. 77, 1970. </td>
	</tr>
	<tr>
		<td>[Schwartz1987]</td>
		<td>N. S. Schwartz, W. E. Clutter, S. D. Shah, and P. E. Cryer, \"Glycemic thresholds for activation of glucose counterregulatory systems are higher than the threshold for symptoms,\" The Journal of Clinical Investigation, vol. 79, pp. 777-781, 1987. </td>
	</tr>
	<tr>
		<td>[Schwartz1996]</td>
		<td>M. W. Schwartz, D. G. Baskin, T. R. Bukowski, J. L. Kuijper, D. Foster, G. Lasser, et al., \"Specificity of leptin action on elevated blood glucose levels and hypothalamic neuropeptide Y gene expression in ob/ob mice,\" Diabetes, vol. 45, pp. 531-535, 1996. </td>
	</tr>
	<tr>
		<td>[Siesjö1973]</td>
		<td>B. Siesjö, \"Metabolic control of intracellular pH,\" Scandinavian Journal of Clinical & Laboratory Investigation, vol. 32, pp. 97-104, 1973. </td>
	</tr>
	<tr>
		<td>[Siesjö1971]</td>
		<td>B. K. Siesjö and L. Nilsson, \"The Influence of Arterial Hypoxemia upon Labile Phosphates and upon Extracellular and Intracellular Lactate and Pyruvate Concentrations in the Rat Brain,\" Scandinavian Journal of Clinical & Laboratory Investigation, vol. 27, pp. 83-96, 1971. </td>
	</tr>
	<tr>
		<td>[Silvers1980]</td>
		<td>G. W. Silvers, T. L. Petty, and R. E. Stanford, \"Elastic recoil changes in early emphysema,\" Thorax, vol. 35, pp. 490-495, July 1, 1980 1980. </td>
	</tr>
	<tr>
		<td>[Silverthorn2007]</td>
		<td>D. U. Silverthorn, B. R. Johnson, and W. C. Ober, Human physiology: Pearson/Benjamin Cummings, 2007. </td>
	</tr>
	<tr>
		<td>[Simpson1971]</td>
		<td>D. P. Simpson, \"Control of hydrogen ion homeostasis and renal acidosis,\" Medicine (Baltimore), vol. 50, pp. 503-41, Nov 1971. </td>
	</tr>
	<tr>
		<td>[Sinclair2005]</td>
		<td>E. M. Sinclair and D. J. Drucker, Proglucagon-Derived Peptides: Mechanisms of Action and Therapeutic Potential vol. 20, 2005. </td>
	</tr>
	<tr>
		<td>[Skarlatos1993]</td>
		<td>S. Skarlatos, N. DiPaola, R. A. Frankel, R. W. Pomerantz, P. H. Brand, P. J. Metting, et al., \"Spontaneous pressure-flow relationships in renal circulation of conscious dogs,\" Am J Physiol, vol. 264, pp. H1517-27, May 1993. </td>
	</tr>
	<tr>
		<td>[Skov1996]</td>
		<td>K. Skov, J. Fenger-Gron, and M. J. Mulvany, \"Effects of an angiotensin-converting enzyme inhibitor, a calcium antagonist, and an endothelin receptor antagonist on renal afferent arteriolar structure,\" Hypertension, vol. 28, pp. 464-471, 1996. </td>
	</tr>
	<tr>
		<td>[Smith2013]</td>
		<td>L. Smith, E. Butterworth, J. Bassingthwaighte, and H. Sauro, \"SBML and CellML translation in Antimony and JSim,\" Bioinformatics, p. btt641, 2013. </td>
	</tr>
	<tr>
		<td>[Sodja2009]</td>
		<td>A. Sodja and B. Zupančič, \"Modelling thermal processes in buildings using an object-oriented approach and Modelica,\" Simulation Modelling Practice and Theory, vol. 17, pp. 1143-1159, 2009. </td>
	</tr>
	<tr>
		<td>[Sonnenberg1973]</td>
		<td>H. Sonnenberg, \"Proximal and distal tubular function in salt-deprived and in salt-loaded deoxycorticosterone acetate-escaped rats,\" Journal of clinical Investigation, vol. 52, p. 263, 1973. </td>
	</tr>
	<tr>
		<td>[Speroff2005]</td>
		<td>L. Speroff and M. A. Fritz, Clinical gynecologic endocrinology and infertility: lippincott Williams & wilkins, 2005. </td>
	</tr>
	<tr>
		<td>[Squires1959]</td>
		<td>R. D. Squires and E. J. Huth, \"Experimental potassium depletion in normal human subjects. I. Relation of ionic intakes to the renal conservation of potassium,\" Journal of Clinical Investigation, vol. 38, p. 1134, 1959. </td>
	</tr>
	<tr>
		<td>[Stainsby1973]</td>
		<td>W. N. Stainsby, \"Local Control of Regional Blood Flow,\" Annual Review of Physiology, vol. 35, pp. 151-168, 1973. </td>
	</tr>
	<tr>
		<td>[Stanton1986]</td>
		<td>B. A. Stanton, \"Regulation by adrenal corticosteroids of sodium and potassium transport in loop of Henle and distal tubule of rat kidney,\" The Journal of Clinical Investigation, vol. 78, pp. 1612-1620, 1986. </td>
	</tr>
	<tr>
		<td>[Starke1987]</td>
		<td>A. Starke, T. Imamura, and R. H. Unger, \"Relationship of glucagon suppression by insulin and somatostatin to the ambient glucose concentration,\" The Journal of Clinical Investigation, vol. 79, pp. 20-24, 1987. </td>
	</tr>
	<tr>
		<td>[Stenvinkel1997]</td>
		<td>P. Stenvinkel, O. Heimbürger, and F. Lönnqvist, \"Serum leptin concentrations correlate to plasma insulin concentrations independent of body fat content in chronic renal failure,\" Nephrology Dialysis Transplantation, vol. 12, pp. 1321-1325, 1997. </td>
	</tr>
	<tr>
		<td>[STERNS1981]</td>
		<td>R. H. STERNS, M. COX, P. U. FEIG, and I. SINGER, \"Internal Potassium Balance and the Control of the Plasma Potassium Concentration,\" Medicine, vol. 60, pp. 339-354, 1981. </td>
	</tr>
[StevensP. M. Stevens and L. E. Lamb, \"Effects of lower body negative pressure on the cardiovascular system,\" American Journal of Cardiology, vol. 16, pp. 506-515.
	<tr>
		<td>[Stewart1981]</td>
		<td>P." + " A. Stewart, How to understand acid-base: a quantitative acid-base primer for biology and medicine: Edward Arnold London, 1981. </td>
	</tr>
	<tr>
		<td>[Stick1992]</td>
		<td>C. Stick, H. Jaeger, and E. Witzleb, Measurements of volume changes and venous pressure in the human lower leg during walking and running vol. 72, 1992. </td>
	</tr>
	<tr>
		<td>[Stone1968]</td>
		<td>H. Stone, Thompson HK, and K. Schmidt-Nielsen, Influence of erythrocytes on blood viscosity vol. 214, 1968. </td>
	</tr>
	<tr>
		<td>[Stonestreet1998]</td>
		<td>B. S. Stonestreet, S. S. Ocampo, and W. Oh, Reductions in cardiac output in hypoxic young pigs: systemic and regional perfusion and oxygen metabolism vol. 85, 1998. </td>
	</tr>
	<tr>
		<td>[Storstein1982]</td>
		<td>L. Storstein, \"Clinical and circulatory aspects of digitalis in heart failure,\" European heart journal, vol. 3, pp. 59-64, 1982. </td>
	</tr>
	<tr>
		<td>[Stothert1992]</td>
		<td>J. C. Stothert, J. O. Basadre, G. B. Gbaanador, J. T. Flynn, L. Traber, and D. Traber, \"Bronchial blood flow during changes in inhaled oxygen and carbon dioxide concentrations in conscious sheep,\" Circulatory shock, vol. 36, pp. 120-126, 1992/02// 1992. </td>
	</tr>
	<tr>
		<td>[Stratton1985]</td>
		<td>J. R. Stratton, M. A. PFEIFER, J. L. Ritchie, and J. B. HALTER, \"Hemodynamic effects of epinephrine- Concentration-effect study in humans,\" Journal of Applied Physiology, vol. 58, pp. 1199-1206, 1985. </td>
	</tr>
	<tr>
		<td>[Suga1979]</td>
		<td>H. Suga, Total mechanical energy of a ventricle model and cardiac oxygen consumption vol. 236, 1979. </td>
	</tr>
	<tr>
		<td>[SUGA1974]</td>
		<td>H. SUGA and K. SAGAWA, \"Instantaneous Pressure-Volume Relationships and Their Ratio in the Excised, Supported Canine Left Ventricle,\" Circulation Research, vol. 35, pp. 117-126, July 1, 1974 1974. </td>
	</tr>
	<tr>
		<td>[SUGA1976]</td>
		<td>H. SUGA, K. SAGAWA, and D. P. KOSTIUK, \"Controls of ventricular contractility assessed by pressure-volume ratio, Emax,\" Cardiovascular Research, vol. 10, pp. 582-592, September 1, 1976 1976. </td>
	</tr>
	<tr>
		<td>[Sugimoto1966]</td>
		<td>T. Sugimoto, K. Sagawa, and A. Guyton, Effect of tachycardia on cardiac output during normal and increased venous return vol. 211, 1966. </td>
	</tr>
	<tr>
		<td>[Summers1997]</td>
		<td>R. L. Summers, J. P. Montani, L. H. Woodward, T. G. Coleman, and J. E. Hall, \"Theoretical analysis of the mechanisms of chronic hyperinsulinemia,\" Computers in Biology and Medicine, vol. 27, pp. 249-256, 5// 1997. </td>
	</tr>
	<tr>
		<td>[SURKS1976]</td>
		<td>M. I. SURKS and J. H. OPPENHEIMER, \"Incomplete Suppression of Thyrotropin Secretion after Single Injection of Large L-Triiodothyronine Doses into Hypothyroid Rats,\" Endocrinology, vol. 99, pp. 1432-1441, 1976. </td>
	</tr>
	<tr>
		<td>[SURKS1977]</td>
		<td>M. I. SURKS and B. M. LIFSCHITZ, \"Biphasic Thyrotropin Suppression in Euthyroid and Hypothyroid Rats,\" Endocrinology, vol. 101, pp. 769-775, 1977. </td>
	</tr>
	<tr>
		<td>[SURKS1977]</td>
		<td>M. I. SURKS and B. M. LIFSCHITZ, \"Biphasic Thyrotropin Suppression in Euthyroid and Hypothyroid Rats,\" Endocrinology, vol. 101, pp. 769-775, 1977. </td>
	</tr>
	<tr>
		<td>[Swanson1975]</td>
		<td>G. D. Swanson and J. W. Bellville, Step changes in end-tidal CO2: methods and implications vol. 39, 1975. </td>
	</tr>
	<tr>
		<td>[Symons1999]</td>
		<td>J. D. Symons, T. I. Musch, K. S. Hageman, and C. L. Stebbins, \"Regional blood flow responses to acute ANG II infusion: effects of nitric oxide synthase inhibition,\" Journal of cardiovascular pharmacology, vol. 34, pp. 116-123, 1999. </td>
	</tr>
	<tr>
		<td>[Szlyk1984]</td>
		<td>P. C. Szlyk, C. King, D. B. Jennings, S. M. Cain, and C. K. Chapler, \"The role of aortic chemoreceptors during acute anemia,\" Canadian journal of physiology and pharmacology, vol. 62, pp. 519-523, 1984/05// 1984. </td>
	</tr>
[SchumackerS. P. T. and C. S. M., \"The concept of a critical oxygen delivery,\" Intensive Care Medicine, vol. 13, pp. 223-229, January 1, 0001.
	<tr>
		<td>[Takeshita1979]</td>
		<td>A. Takeshita, A. L. Mark, D. L. Eckberg, and F. M. Abboud, Effect of central venous pressure on arterial baroreflex control of heart rate vol. 236, 1979. </td>
	</tr>
	<tr>
		<td>[Talbott1941]</td>
		<td>J. H. Talbott, \"The Physiologic and Therapeutic Effects of Hypothermia,\" New England Journal of Medicine, vol. 224, pp. 281-288, 1941. </td>
	</tr>
	<tr>
		<td>[Laboratory2008]</td>
		<td>L. o. B. a. C. A. Teaching. (2008). Physiolibrary in Matlab and Simuling. Available: http://www.physiome.cz/simchips </td>
	</tr>
	<tr>
		<td>[Thomas1974]</td>
		<td>R. C. Thomas, \"Intracellular pH of snail neurones measured with a new pH-sensitive glass micro-electrode,\" The Journal of Physiology, vol. 238, pp. 159-180, April 1, 1974 1974. </td>
	</tr>
	<tr>
		<td>[Thomas1976]</td>
		<td>R. C. Thomas, \"The effect of carbon dioxide on the intracellular pH and buffering power of snail neurones,\" The Journal of Physiology, vol. 255, pp. 715-735, March 1, 1976 1976. </td>
	</tr>
	<tr>
		<td>[Thomas1977]</td>
		<td>R. C. Thomas, \"The role of bicarbonate, chloride and sodium ions in the regulation of intracellular pH in snail neurones,\" The Journal of Physiology, vol. 273, pp. 317-338, December 1, 1977 1977. </td>
	</tr>
	<tr>
		<td>[Thomas1998]</td>
		<td>S. R. Thomas, \"Cycles and separations in a model of the renal medulla,\" American Journal of Physiology-Renal Physiology, vol. 275, pp. F671-F690, 1998. </td>
	</tr>
	<tr>
		<td>[Thompson1928]</td>
		<td>W. O. Thompson, P. K. Thompson, and M. E. Dailey, \"THE EFFECT OF POSTURE UPON THE COMPOSITION AND VOLUME OF THE BLOOD IN MAN 1,\" The Journal of Clinical Investigation, vol. 5, pp. 573-604, 1928. </td>
	</tr>
	<tr>
		<td>[Tikkanen1985]</td>
		<td>I. Tikkanen, K. Metsärinne, F. Fyhrquist, and R. Leidenius, \"Plasma atrial natriuretic peptide in cardiac disease and during infusion in healthy volunteers,\" The Lancet, vol. 326, pp. 66-69, 1985. </td>
	</tr>
	<tr>
		<td>[Topor2004]</td>
		<td>Z. Topor, M. Pawlicki, and J. Remmers, \"A Computational Model of the Human Respiratory Control System: Responses to Hypoxia and Hypercapnia,\" Annals of Biomedical Engineering, vol. 32, pp. 1530-1545, 2004/11/01 2004. </td>
	</tr>
	<tr>
		<td>[Toussaint1962]</td>
		<td>C. Toussaint and P. Vereerstraeten, Effects of blood pH changes on potassium excretion in the dog vol. 202, 1962. </td>
	</tr>
	<tr>
		<td>[Tummescheit2002]</td>
		<td>H. Tummescheit, \"Design and implementation of object-oriented model libraries using modelica,\" 2002. </td>
	</tr>
	<tr>
		<td>[Tummescheit1998]</td>
		<td>H. Tummescheit and J. Eborn, \"Design of a thermo-hydraulic model library in Modelica,\" in 12th European Simulation Multiconference, 1998. </td>
	</tr>
	<tr>
		<td>[Turcotte1999]</td>
		<td>L. P. Turcotte, \"ROLE OF FATS IN EXERCISE: Types and Quality,\" Clinics in Sports Medicine, vol. 18, pp. 485-498, 7/1/ 1999. </td>
	</tr>
	<tr>
		<td>[Unger1970]</td>
		<td>R. H. Unger, E. Aguilar-Parada, xFc, W. A. ller, and A. M. Eisentraut, \"Studies of pancreatic alpha cell function in normal and diabetic subjects,\" The Journal of Clinical Investigation, vol. 49, pp. 837-848, 1970. </td>
	</tr>
	<tr>
		<td>[Ursino2001]</td>
		<td>M. Ursino, E. Magosso, and G. Avanzolini, \"An integrated model of the human ventilatory control system: the response to hypoxia,\" Clinical Physiology, vol. 21, pp. 465-477, 2001. </td>
	</tr>
	<tr>
		<td>[Van1999]</td>
		<td>P. Van De Borne, S. Heron, H. Nguyen, P. Unger, M. Leeman, J. L. Vincent, et al., \"Arterial baroreflex control of the sinus node during dobutamine exercise stress testing,\" Hypertension, vol. 33, pp. 987-991, 1999. </td>
	</tr>
	<tr>
		<td>[Van1928]</td>
		<td>D. D. Van Slyke, A. B. Hastings, A. Hiller, and J. Sendroy, \"STUDIES OF GAS AND ELECTROLYTE EQUILIBRIA IN BLOOD: XIV. THE AMOUNTS OF ALKALI BOUND BY SERUM ALBUMIN AND GLOBULIN,\" Journal of Biological Chemistry, vol. 79, pp. 769-780, October 1, 1928 1928. </td>
	</tr>
	<tr>
		<td>[VANDERWEELE1993]</td>
		<td>D. A. VANDERWEELE and T. R. SCOTT, \"Pancreatic glucagon suppresses gustatory responsiveness to glucose,\" 1993. </td>
	</tr>
	<tr>
		<td>[Verrey1996]</td>
		<td>F. Verrey and J. Beron, \"Activation and supply of channels and pumps by aldosterone,\" News in physiological sciences, vol. 11, pp. 126-132, 1996. </td>
	</tr>
	<tr>
		<td>[Vizek1987]</td>
		<td>M. Vizek, C. K. Pickett, and J. V. Weil, Increased carotid body hypoxic sensitivity during acclimatization to hypobaric hypoxia vol. 63, 1987. </td>
	</tr>
	<tr>
		<td>[Wade1970]</td>
		<td>J. G. Wade, C. P. Larson, R. F. Hickey, W. K. Ehrenfeld, and J. W. Severinghaus, \"Effect of Carotid Endarterectomy on Carotid Chemoreceptor and Baroreceptor Function in Man,\" New England Journal of Medicine, vol. 282, pp. 823-829, 1970. </td>
	</tr>
	<tr>
		<td>[Wagner1988]</td>
		<td>E. M. Wagner and W. A. Mitzner, \"Effect of hypoxia on bronchial circulation,\" J. Appl. Physiol, vol. 65, pp. 1627-1633, 1988. </td>
	</tr>
	<tr>
		<td>[Wagner1990]</td>
		<td>E. M. Wagner and W. A. Mitzner, \"Effect of left atrial pressure on bronchial vascular hemodynamics,\" J Appl Physiol, vol. 69, pp. 837-842, 1990. </td>
	</tr>
	<tr>
		<td>[Wagner2004]</td>
		<td>E. M. Wagner, D. Kratky, G. Haemmerle, A. Hrzenjak, G. M. Kostner, E. Steyrer, et al., \"Defective uptake of triglyceride-associated fatty acids in adipose tissue causes the SREBP-1c-mediated induction of lipogenesis,\" Journal of lipid research, vol. 45, pp. 356-365, 2004. </td>
	</tr>
	<tr>
		<td>[Wahren1970]</td>
		<td>J. Wahren, \"Human forearm muscle metabolism during exercise. IV. Glucose uptake at different work intensities,\" Scandinavian Journal of Clinical and Laboratory Investigation, vol. 25, pp. 129-135, 1970/03// 1970. </td>
	</tr>
	<tr>
		<td>[Wahren2007]</td>
		<td>J. Wahren and K. Ekberg, \"Splanchnic regulation of glucose production,\" Annu. Rev. Nutr., vol. 27, pp. 329-345, 2007. </td>
	</tr>
	<tr>
		<td>[Warner1962]</td>
		<td>H. R. Warner and A. Cox, A mathematical model of heart rate control by sympathetic and vagus efferent information vol. 17, 1962. </td>
	</tr>
	<tr>
		<td>[Warren1943]</td>
		<td>J. V. Warren, A. J. Merrill, and E. A. Stead, Jr., \"THE RÔLE OF THE EXTRACELLULAR FLUID IN THE MAINTENANCE OF A NORMAL PLASMA VOLUME,\" The Journal of Clinical Investigation, vol. 22, pp. 635-641, 1943. </td>
	</tr>
	<tr>
		<td>[Waterlow1967]</td>
		<td>J. C. Waterlow, \"Lysine turnover in man measured by intravenous infusion of L-</td>
	</tr>
	<tr>
		<td>[U-14C]</td>
		<td>1993]	P. D. Watson, \"Sieving of electrolytes at capillary wall of cat skeletal muscle by osmotic water flow,\" AMERICAN JOURNAL OF PHYSIOLOGY, vol. 265, pp. H1869-H1869, 1993. </td>
	</tr>
	<tr>
		<td>[Weber1977]</td>
		<td>K. T. Weber and J. S. Janicki, Myocardial oxygen consumption: the role of wall force and shortening vol. 233, 1977. </td>
	</tr>
	<tr>
		<td>[Weber2000]</td>
		<td>D. S. Weber and J. H. Lombard, Elevated salt intake impairs dilation of rat skeletal muscle resistance arteries via ANG II suppression vol. 278, 2000. </td>
	</tr>
	<tr>
		<td>[Weidmann1978]</td>
		<td>P. Weidmann, C. Beretta-Piccoli, W. H. Ziegler, G. Keusch, Z. Gluck, and F. C. Reubi, \"Age versus urinary sodium for judging renin, aldosterone, and catecholamine levels: Studies in normal subjects and patients with essential hypertension,\" Kidney Int, vol. 14, pp. 619-628, 12//print 1978. </td>
	</tr>
	<tr>
		<td>[Weidmann1986]</td>
		<td>P. Weidmann, L. Hasler, M. Gnädinger, R. E. Lang, D. E. Uehlinger, S. Shaw, et al., \"Blood levels and renal effects of atrial natriuretic peptide in normal man,\" Journal of Clinical Investigation, vol. 77, p. 734, 1986. </td>
	</tr>
	<tr>
		<td>[Weil1971]</td>
		<td>J. V. Weil, E. Byrne-Quinn, I. E. Sodal, G. F. Filley, and R. F. Grover, \"Acquired attenuation of chemoreceptor function in chronically hypoxic man at high altitude,\" The Journal of Clinical Investigation, vol. 50, pp. 186-195, 1971. </td>
	</tr>
	<tr>
		<td>[Wells1938]</td>
		<td>H. S. Wells, J. B. Youmans, and D. G. Miller, Jr., \"TISSUE PRESSURE (INTRACUTANEOUS, SUBCUTANEOUS, AND INTRAMUSCULAR) AS RELATED TO VENOUS PRESSURE, CAPILLARY FILTRATION, AND OTHER FACTORS 12,\" The Journal of Clinical Investigation, vol. 17, pp. 489-499, 1938. </td>
	</tr>
	<tr>
		<td>[Wennergren1976]</td>
		<td>G. Wennergren, R. Little, and B. ÖBerg, \"Studies on the central integration of excitatory chemoreceptor influences and inhibitory baroreceptor and cardiac receptor influences,\" Acta Physiologica Scandinavica, vol. 96, pp. 1-18, 1976. </td>
	</tr>
	<tr>
		<td>[Wetter2013]</td>
		<td>M. Wetter, \"Modeling of Heat Transfer in Rooms in the Modelica Buildings Library,\" 2013. </td>
	</tr>
	<tr>
		<td>[Whalen1974]</td>
		<td>W. Whalen, P. Nair, D. Buerk, and C. Thuning, \"Tissue PO2 in normal and denervated cat skeletal muscle,\" Am J Physiol, vol. 227, pp. 1221-1225, 1974. </td>
	</tr>
	<tr>
		<td>[Whittaker1933]</td>
		<td>S. R. F. Whittaker and F. R. Winton, \"The apparent viscosity of blood flowing in the isolated hindlimb of the dog, and its variation with corpuscular concentration,\" The Journal of Physiology, vol. 78, pp. 339-369, July 10, 1933 1933. </td>
	</tr>
	<tr>
		<td>[Widmaier2006]</td>
		<td>E. P. Widmaier, H. Raff, and K. T. Strang, Vander's human physiology: McGraw-Hill Higher Education, 2006. </td>
	</tr>
	<tr>
		<td>[Wiederholt1967]</td>
		<td>M. Wiederholt, K. Hierholzer, E. Windhager, and G. Giebisch, Microperfusion study of fluid reabsorption in proximal tubules of rat kidneys vol. 213, 1967. </td>
	</tr>
	<tr>
		<td>[WILLIAMS1977]</td>
		<td>G. H. WILLIAMS and L. M. BRALEY, \"Effects of dietary sodium and potassium intake and acute stimulation on aldosterone output by isolated human adrenal cells,\" The Journal of Clinical Endocrinology & Metabolism, vol. 45, pp. 55-64, 1977. </td>
	</tr>
	<tr>
		<td>[L.1989]</td>
		<td>L. R. Williams and R. W. Leggett, \"Reference values for resting blood flow to organs of man,\" Clinical Physics and Physiological Measurement, vol. 10, p. 187, 1989. </td>
	</tr>
	<tr>
		<td>[Williamson1993]</td>
		<td>J. Williamson and P. B. Raven, \"Unilateral carotid-cardiac baroreflex responses in humans,\" American Journal of Physiology, vol. 265, pp. H1033-H1033, 1993. </td>
	</tr>
	<tr>
		<td>[Williamson1993]</td>
		<td>J. Williamson and P. B. Raven, \"Unilateral carotid-cardiac baroreflex responses in humans,\" American Journal of Physiology, vol. 265, pp. H1033-H1033, 1993. </td>
	</tr>
	<tr>
		<td>[Winearls1986]</td>
		<td>C. Winearls, M. Pippard, M. Downing, D. Oliver, C. Reid, and P. Mary Cotes, \"EFFECT OF HUMAN ERYTHROPOIETIN DERIVED FROM RECOMBINANT DNA ON THE ANAEMIA OF PATIENTS MAINTAINED BY CHRONIC HAEMODIALYSIS,\" The Lancet, vol. 328, pp. 1175-1178, 11/22/ 1986. </td>
	</tr>
	<tr>
		<td>[Winegrad1971]</td>
		<td>A. I. Winegrad and R. S. Clements Jr, \"Diabetic ketoacidosis,\" The Medical clinics of North America, vol. 55, pp. 899-911, 1971. </td>
	</tr>
	<tr>
		<td>[WINER1969]</td>
		<td>N. WINER, D. S. CHOKSHI, M. S. YOON, and A. D. FREEDMAN, \"Adrenergic receptor mediation of renin secretion,\" The Journal of Clinical Endocrinology & Metabolism, vol. 29, pp. 1168-1175, 1969. </td>
	</tr>
	<tr>
		<td>[Wolfe1998]</td>
		<td>R. R. Wolfe, \"Metabolic interactions between glucose and fatty acids in humans,\" The American Journal of Clinical Nutrition, vol. 67, pp. 519S-526S, March 1, 1998 1998. </td>
	</tr>
	<tr>
		<td>[Wolgast1981]</td>
		<td>M. Wolgast, M. Larson, and K. Nygren, \"Functional characteristics of the renal interstitium,\" American Journal of Physiology-Renal Physiology, vol. 241, pp. F105-F111, 1981. </td>
	</tr>
	<tr>
		<td>[WOLLHEIM1964]</td>
		<td>F. A. WOLLHEIM, S. BELFRAGE, C. CÖSTER, and H. LINDHOLM, \"Primary “acquired” hypogammaglobulinemia,\" Acta medica Scandinavica, vol. 176, pp. 1-16, 1964. </td>
	</tr>
	<tr>
		<td>[Wong2004]</td>
		<td>S. L. Wong, A. M. DePaoli, J. H. Lee, and C. S. Mantzoros, \"Leptin hormonal kinetics in the fed state: effects of adiposity, age, and gender on endogenous leptin production and clearance rates,\" The Journal of Clinical Endocrinology & Metabolism, vol. 89, pp. 2672-2677, 2004. </td>
	</tr>
	<tr>
		<td>[Woo1972]</td>
		<td>S. L. Y. Woo, A. S. Kobayashi, C. Lawrence, and W. A. Schlegel, \"Mathematical model of the corneo-scleral shell as applied to intraocular pressure-volume relations and applanation tonometry,\" Annals of Biomedical Engineering, vol. 1, pp. 87-98, 1972/09/01 1972. </td>
	</tr>
	<tr>
		<td>[Woodbury1956]</td>
		<td>D. M. Woodbury, \"Effect of acute hyponatremia on distribution of water and electrolytes in various tissues of the rat,\" Am. J. Physiol, vol. 185, pp. 281-286, 1956. </td>
	</tr>
	<tr>
		<td>[Work1987]</td>
		<td>J. Work and R. L. Jamison, \"Effect of adrenalectomy on transport in the rat medullary thick ascending limb,\" J Clin Invest, vol. 80, pp. 1160-4, Oct 1987. </td>
	</tr>
	<tr>
		<td>[Wright1982]</td>
		<td>F. S. Wright, \"Flow-dependent transport processes: filtration, absorption, secretion,\" Am J Physiol, vol. 243, pp. F1-11, Jul 1982. </td>
	</tr>
	<tr>
		<td>[Wyndham1966]</td>
		<td>C. H. Wyndham, N. B. Strydom, J. F. Morrison, C. G. Williams, G. A. Bredell, and J. Peter, Fatigue of the sweat gland response vol. 21, 1966. </td>
	</tr>
	<tr>
		<td>[Xenopoulos1994]</td>
		<td>N. P. Xenopoulos and R. J. Applegate, \"The effect of vagal stimulation on left ventricular systolic and diastolic performance,\" American Journal of Physiology-Heart and Circulatory Physiology, vol. 35, p. H2167, 1994. </td>
	</tr>
	<tr>
		<td>[Xie1995]</td>
		<td>S. Xie, R. Reed, B. Bowen, and J. Bert, \"A model of human microvascular exchange,\" Microvascular research, vol. 49, pp. 141-162, 1995. </td>
	</tr>
	<tr>
		<td>[Xie1995]</td>
		<td>S. L. Xie, R. K. Reed, B. D. Bowen, and J. L. Bert, \"A Model of Human Microvascular Exchange,\" Microvascular Research, vol. 49, pp. 141-162, 3// 1995. </td>
	</tr>
	<tr>
		<td>[Yandle1986]</td>
		<td>T. G. Yandle, A. M. Richards, M. G. Nicholls, R. Cuneo, E. A. Espiner, and J. H. Livesey, \"Metabolic clearance rate and plasma half life of alpha-human atrial natriuretic peptide in man,\" Life Sci, vol. 38, pp. 1827-33, May 19 1986. </td>
	</tr>
	<tr>
		<td>[Young1982]</td>
		<td>D. B. Young, \"Relationship between plasma potassium concentration and renal potassium excretion,\" Am J Physiol, vol. 242, pp. F599-F603, 1982. </td>
	</tr>
	<tr>
		<td>[Young1988]</td>
		<td>D. B. Young, Quantitative analysis of aldosterone's role in potassium regulation vol. 255, 1988. </td>
	</tr>
	<tr>
		<td>[Young1983]</td>
		<td>D. B. Young and A. W. Paulsen, \"Interrelated effects of aldosterone and plasma potassium on potassium excretion,\" Am J Physiol, vol. 244, pp. F28-F34, 1983. </td>
	</tr>
	<tr>
		<td>[Young1977]</td>
		<td>D. B. Young, Y. Pan, and A. C. Guyton, \"Control of extracellular sodium concentration by antidiuretic hormone-thirst feedback mechanism,\" Am J Physiol, vol. 232, 1977. </td>
	</tr>
	<tr>
		<td>[Young1976]</td>
		<td>D. B. Young, R. E. McCAA, Y.-J. Pan, and A. C. Guyton, \"Effectiveness of the aldosterone sodium and potassium feedback control system,\" Am. J. Physiol, vol. 231, pp. 945-953, 1976. </td>
	</tr>
	<tr>
		<td>[Young1984]</td>
		<td>D. B. Young, T. E. Jackson, U. Tipayamontri, and R. C. Scott, Effects of sodium intake on steady-state potassium excretion vol. 246, 1984. </td>
	</tr>
	<tr>
		<td>[Young1984]</td>
		<td>D. B. Young, T. E. Jackson, U. Tipayamontri, and R. C. Scott, Effects of sodium intake on steady-state potassium excretion vol. 246, 1984. </td>
	</tr>
	<tr>
		<td>[Zachariah1986]</td>
		<td>P. K. Zachariah, D. C. Bloedow, T. P. Moyer, S. G. Sheps, A. Schirger, and R. D. Fealey, \"Pharmacodynamics of midodrine, an antihypotensive agent,\" Clin Pharmacol Ther, vol. 39, pp. 586-91, May 1986. </td>
	</tr>
	<tr>
		<td>[Zambraski1976]</td>
		<td>E. J. Zambraski, G. F. DiBona, and G. J. Kaloyanides, \"Specificity of Neural Effect on Renal Tubular Sodium Reabsorption,\" Experimental Biology and Medicine, vol. 151, pp. 543-546, March 1, 1976 1976. </td>
	</tr>
	<tr>
		<td>[Zou1998]</td>
		<td>A.-P. Zou, F. Wu, and A. W. Cowley, \"Protective effect of angiotensin II-induced increase in nitric oxide in the renal medullary circulation,\" Hypertension, vol. 31, pp. 271-276, 1998. </td>
	</tr>
	<tr>
		<td>[Zupančič2013]</td>
		<td>B. Zupančič and A. Sodja, \"Computer-aided physical multi-domain modelling: Some experiences from education and industrial applications,\" Simulation Modelling Practice and Theory, vol. 33, pp. 45-67, 2013.  </td>
	</tr>

</table>
</html>"));
  end References;

class License "Physiomodel License"
  extends Modelica.Icons.Information;

  annotation (Documentation(info="<html>

            <p>Copyright (c) 2008-2015, Marek Mateják, Charles University in Prague. All rights reserved.</p>

      <p>Everybody can use Physiomodel in conditions of the <a href=\"http://www.gnu.org/licenses/gpl-3.0.en.html\">GNU General Public License 3.0</a> (GPL).</p>

      <p>Registered parties in the following table can use the assigned Physiomodel versions in the conditions of the <a href=\"http://opensource.org/licenses/BSD-3-Clause\">BSD 3-Clause license</a> (BSD) or GPL of their choice.</p>

      <table>
	      <tr>
	           <th>Registered Individuals</th><th>Role</th><th>Physiomodel Versions</th>
	      </tr>
	      <tr>
		      <td>Marek Mateják</td><td>contributor</td><td>1.0.0</td>
	      </tr>
	      <tr>
		      <td>Thomas G. Coleman</td><td>cooperator</td><td>1.0.0</td>
	      </tr>
	      <tr>
		      <td>Robert L. Hester</td><td>cooperator</td><td>1.0.0</td>
	      </tr>
	      <tr>
		      <td>Jiří Kofránek</td><td>cooperator</td><td>1.0.0</td>
	      </tr>
	      <tr>
		      <td>Tomáš Kulhánek</td><td>partner</td><td>1.0.0</td>
	      </tr>
	      <tr>
		      <td>Filip Ježek</td><td>partner</td><td>1.0.0</td>
	      </tr>
	      <tr>
		      <td>William A. Pruett</td><td>partner</td><td>1.0.0</td>
	      </tr>
	      <tr>
		  <th>Registered Universities</th><th>Role</th><th>Physiomodel Versions</th>
	      </tr>
	      <tr>
		      <td>Charles University in Prague</td><td>contributor</td><td>1.0.0</td>
	      </tr>
	      <tr>
		      <td>University of Mississippi Medical Centre</td><td>cooperator</td><td>1.0.0</td>
	      </tr>
	      <tr>
	          <th>Registered Companies</th><th>Role</th><th>Physiomodel Versions</th>
	      </tr>
	      <tr>
		      <td>Creative Connection s.r.o.</td><td>partner</td><td>1.0.0</td>
	      </tr>
	      <tr>
		      <td>HC Simulations, LLC</td><td>partner</td><td>1.0.0</td>
	      </tr>
      </table>


      <p>Specified version of Physiomodel can be distributed under this license as a part of the following registered simulation environments:</p>

       <table>
	      <tr>
		      <th>Registered simulation environment</th><th>Owner</th><th>Physiomodel Versions</th>
	      </tr>
	      <tr>
		      <td><a href=\"https://openmodelica.org/\">OpenModelica</a></td><td>Open Source Modelica Consortium</td><td>1.0.0</td></tr>
	      <tr><td><a href=\"http://www.wolfram.com/system-modeler/\">System Modeler</a></td><td>Wolfram</td><td>1.0.0</td></tr>
      </table>


<pre>
GPL 3.0 license statement:

    Physiomodel is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License 3.0 as published by
    the Free Software Foundation.

    Physiomodel is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Physiomodel.  If not, see <a href=\"http://www.gnu.org/licenses/gpl-3.0.en.html\">http://www.gnu.org/licenses/</a>.

BSD 3-Clause License:

    Redistribution and use in source and binary forms, with or without
    modification, are permitted provided that the following conditions
    are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer
        in the documentation and/or other materials provided with the
        distribution.

     3. Neither the name of the copyright holder nor the names of its
        contributors may be used to endorse or promote products derived
        from this software without specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
    \"AS IS\" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT
    NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
    FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
    HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
    SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
    PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
    OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
    WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
    OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
    IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
</pre>

    <p>Other distribution of Physiomodel (unchanged or modified) than under these conditions is prohibited without specific prior written permissions or licenses.</p>

</html>"));
end License;

  class Contact "Contact"
    extends Modelica.Icons.Contact;

    annotation (Documentation(info="<html>
<p>This package is developed an maintained by the following contributors </p>
<table cellspacing=\"0\" cellpadding=\"2\" border=\"1\"><tr>
<td></td>
<td><p align=\"center\"><h4>Name</h4></p></td>
<td><p align=\"center\"><h4>Affiliation</h4></p></td>
</tr>
<tr>
<td valign=\"top\">Contributor</td>
<td valign=\"top\"><a href=\"marek@matfyz.cz\">Marek Matejak</a></td>
<td valign=\"top\">
<a href=\"http://www.cuni.cz\">Charles University in Prague</a>,<br/>
<a href=\"http://www.lf1.cuni.cz\">First Faculty of Medicine</a>,<br/>
<a href=\"http://patofyziologie.lf1.cuni.cz/en\">Institute of Pathological Physiology</a>,<br/>
U Nemocnice 5,<br/>
Praha 2, 128 53<br/>
Czech Republic
</td>
</tr>
</table>
</html>"));
  end Contact;

class NewRealease "Publishing new release"
  extends Modelica.Icons.Information;

 annotation (Documentation(info="<html>
<p><br>New release must be numbered by Semantic Versioning 2.0, see <a href=\"http://semver.org/\">semver.org</a>. </p>
<p><br>If minor version, then the conversion script must be written and connected with package Physiomodel using &QUOT;annotation(conversion(from(version=..)))&QUOT;! </p>
<p><br>To clean the code from dummy annotations try to use script <a href=\"https://github.com/dietmarw/trimtrailingwhitespaces\">ttws</a>. </p>
<p><br>Update version number to &QUOT;X.Y.Z&QUOT;: </p>
<ul>
<li>At package Physiomodel annotation: (version=&QUOT;X.Y.Z&QUOT;) together with &QUOT;versionBuild&QUOT;, &QUOT;versionDate&QUOT; and &QUOT;dateModified&QUOT; attribute </li>
<li>At file &QUOT;./Physiomodel/libraryinfo.mos&QUOT; </li>
</ul>
<p><br>Update release notes: </p>
<ul>
<li>At UsersGuide.ReleaseNotes</li>
<li>At file &QUOT;./README.md&QUOT;, together with update of &QUOT;Current release&QUOT; section.</li>
</ul>
<p><br>Publish release in GitHub: </p>
<ul>
<li>Prepare release in &QUOT;master&QUOT; branch</li>
<li>Install, Check, Test, Test, Test (stop-time of examples).. </li>
<li>Delete branch &QUOT;release&QUOT; </li>
<li>Create new branch &QUOT;release&QUOT; from &QUOT;master&QUOT; branch </li>
<li>Rename directory &QUOT;Physiomodel&QUOT; in release branch to directory &QUOT;Physiomodel X.Y.Z&QUOT; </li>
<li>Commint and Push </li>
<li>Draft a new release from &QUOT;release&QUOT; branch with number &QUOT;vX.Y.Z&QUOT; and with release notes. </li>
</ul>
</html>"));
end NewRealease;

package ReleaseNotes "Release notes"
  extends Modelica.Icons.ReleaseNotes;

class Version_1_0 "Version 1.0.0 (Oct. 12, 2015)"
  extends Modelica.Icons.ReleaseNotes;

annotation (Documentation(info="<html>
<p>Quantitative model of human physiology in Modelica based on <a href=\"htp://www.hummod.org\">HumMod 1.6.1</a> and <a href=\"htp://www.physiolibrary.org\">Physiolibrary 2.3.1</a>.</p>
</html>"));
end Version_1_0;
 annotation (Documentation(info="<html>
<p>This section summarizes the changes that have been performed on the Physiomodel. </p>
</html>"));
end ReleaseNotes;
annotation (__Dymola_DocumentationClass=true, Documentation(info="<html>
</html>"));
end UsersGuide;
